/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.libs.LCImageDataProvider;
import com.lightcrafts.image.libs.LCImageDataReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ImageProviderReceiver
implements LCImageDataProvider,
LCImageDataReceiver {
    private List<ByteBuffer> data = new LinkedList<ByteBuffer>();
    private Iterator<ByteBuffer> iter;
    private ByteBuffer current;

    ImageProviderReceiver() {
    }

    void fill(InputStream in) throws IOException {
        while (in.available() > 0) {
            int available = in.available();
            int chunkSize = Math.max(1024, available);
            byte[] chunk = new byte[chunkSize];
            int read = in.read(chunk);
            ByteBuffer buf = ByteBuffer.wrap(chunk, 0, read);
            this.putImageData(buf);
            if (read >= chunkSize) continue;
            break;
        }
    }

    @Override
    public int putImageData(ByteBuffer buf) {
        buf.rewind();
        ByteBuffer chunk = ByteBuffer.allocate(buf.remaining());
        chunk.put(buf);
        this.data.add(chunk);
        return chunk.capacity();
    }

    @Override
    public int getImageData(ByteBuffer buf) {
        buf.clear();
        if (this.iter == null) {
            this.iter = this.data.iterator();
        }
        int written = 0;
        while (buf.remaining() > 0 && (this.current != null && this.current.remaining() > 0 || this.iter.hasNext())) {
            if (this.current == null || this.current.remaining() == 0) {
                this.current = this.iter.next().duplicate();
                this.current.rewind();
            }
            if (this.current.remaining() <= buf.remaining()) {
                written += this.current.remaining();
                buf.put(this.current);
                continue;
            }
            byte[] data = this.current.array();
            int amount = buf.remaining();
            written += amount;
            buf.put(data, this.current.position(), amount);
            this.current.position(this.current.position() + amount);
        }
        return written;
    }
}

