/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import com.lightcrafts.ui.browser.folders.WindowsFolderTreeCellRenderer;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class FolderTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Font normalFont;

    static TreeCellRenderer createRenderer() {
        return Platform.getType() == Platform.Windows ? new WindowsFolderTreeCellRenderer() : new FolderTreeCellRenderer();
    }

    FolderTreeCellRenderer() {
        this.setBackgroundNonSelectionColor(LightZoneSkin.Colors.ToolPanesBackground);
        this.setTextNonSelectionColor(LightZoneSkin.Colors.ToolPanesForeground);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        FolderTreeNode node = (FolderTreeNode)value;
        this.setIcon(node.getIcon());
        if (this.normalFont == null) {
            this.normalFont = this.getFont();
        }
        if (node.isDropTarget()) {
            Font font = this.normalFont.deriveFont(1);
            this.setFont(font);
        } else {
            this.setFont(this.normalFont);
        }
        return this;
    }
}

