/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.browser.ctrls.NavigationPane;
import com.lightcrafts.ui.browser.folders.FolderPathsSaver;
import com.lightcrafts.ui.browser.folders.FolderTree;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.ui.browser.folders.FolderTreeModel;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import com.lightcrafts.ui.datatips.xswing.DataTipManager;
import com.lightcrafts.ui.toolkit.MenuButton;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class FolderBrowserPane
extends JScrollPane
implements TreeSelectionListener {
    private FolderTree tree;
    private Stack<FolderTreeNode> backStack;
    private Stack<FolderTreeNode> forwardStack;
    private MenuButton pathButton = new MenuButton();
    private boolean inSyntheticSelectionChange;

    public FolderBrowserPane() {
        this.tree = new FolderTree();
        this.backStack = new Stack();
        this.forwardStack = new Stack();
        this.setBorder(null);
        TreePath path = FolderPathsSaver.getLatestPath(this.tree);
        FolderPathsSaver.addToTree(this.tree);
        Font treeFont = this.tree.getFont();
        this.tree.setFont(treeFont.deriveFont((float)(treeFont.getSize() - 1)));
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.setSelectionPath(path);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.getViewport().setView(this.tree);
        if (Platform.getType() != Platform.MacOSX) {
            DataTipManager.get().register(this.tree);
        }
    }

    public boolean goToPicturesFolder() {
        return this.tree.goToPicturesFolder();
    }

    public synchronized void dispose() {
        if (Platform.getType() != Platform.MacOSX) {
            DataTipManager.get().unregister(this.tree);
        }
        this.tree.dispose();
        this.tree = null;
    }

    public DirectoryMonitor getDirectoryMonitor() {
        return ((FolderTreeModel)this.tree.getModel()).getDirectoryMonitor();
    }

    public MenuButton getPathPopupMenu() {
        return this.pathButton;
    }

    public void goBack() {
        if (this.isBackAvailable()) {
            FolderTreeNode node = this.tree.getSelectedNode();
            this.forwardStack.push(node);
            this.setSelectedNode(this.backStack.pop());
        }
    }

    public void goForward() {
        if (this.isForwardAvailable()) {
            FolderTreeNode node = this.tree.getSelectedNode();
            this.backStack.push(node);
            this.setSelectedNode(this.forwardStack.pop());
        }
    }

    public boolean isBackAvailable() {
        return !this.backStack.empty();
    }

    public boolean isForwardAvailable() {
        return !this.forwardStack.empty();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath oldPath = e.getOldLeadSelectionPath();
        FolderTreeNode oldNode = oldPath != null ? (FolderTreeNode)oldPath.getLastPathComponent() : null;
        TreePath newPath = e.getNewLeadSelectionPath();
        FolderTreeNode newNode = newPath != null ? (FolderTreeNode)newPath.getLastPathComponent() : null;
        this.pathButton.clear();
        for (FolderTreeNode node = newNode; node != null; node = (FolderTreeNode)node.getParent()) {
            String name = node.toString();
            Icon icon = node.getIcon();
            JMenuItem menuItem = new JMenuItem(name, icon);
            final FolderTreeNode menuCurrent = newNode;
            final FolderTreeNode menuSelection = node;
            final boolean modifyStack = newNode != node;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (modifyStack) {
                        FolderBrowserPane.this.backStack.push(menuCurrent);
                        FolderBrowserPane.this.forwardStack.clear();
                    }
                    FolderBrowserPane.this.setSelectedNode(menuSelection);
                }
            });
            this.pathButton.add(menuItem);
        }
        if (!this.inSyntheticSelectionChange) {
            this.backStack.push(oldNode);
            this.forwardStack.clear();
        }
    }

    public void addSelectionListener(FolderTreeListener listener) {
        this.tree.addFolderTreeListener(listener);
    }

    public void removeSelectionListener(FolderTreeListener listener) {
        this.tree.removeFolderTreeListener(listener);
    }

    public File getSelectedFile() {
        FolderTreeNode node = this.tree.getSelectedNode();
        return node != null ? node.getFile() : null;
    }

    public void savePath(String key) {
        FolderPathsSaver.savePath(this.tree, key);
    }

    public void restorePath(String key) {
        FolderPathsSaver.restorePath(this.tree, key);
    }

    public static void clearPath(String key) {
        FolderPathsSaver.clearPath(key);
    }

    private void setSelectedNode(FolderTreeNode node) {
        this.inSyntheticSelectionChange = true;
        if (node != null) {
            TreePath path = node.getTreePath();
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        } else {
            this.tree.clearSelection();
        }
        this.inSyntheticSelectionChange = false;
    }

    public static void main(String[] args) {
        FolderBrowserPane browser = new FolderBrowserPane();
        browser.goToPicturesFolder();
        NavigationPane buttons = new NavigationPane(browser);
        JFrame frame = new JFrame("Test");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(browser);
        frame.getContentPane().add((Component)buttons, "North");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        DirectoryMonitor monitor = browser.getDirectoryMonitor();
        monitor.resume(false);
    }
}

