/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.model.ImageTaskQueueListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class QueueDepthProgress
extends JPanel
implements ImageTaskQueueListener {
    private JProgressBar progress;

    public QueueDepthProgress(ImageList list) {
        this.setLayout(new BorderLayout());
        list.addQueueListener(this);
        this.setFixedSize();
    }

    @Override
    public void queueDepthChanged(int depth) {
        if (depth > 0) {
            int max;
            if (this.progress == null) {
                this.addProgressBar();
            }
            if (depth > (max = this.progress.getMaximum())) {
                this.progress.setMaximum(depth);
            }
            this.progress.setValue(max - depth);
        } else if (this.progress != null) {
            this.removeProgressBar();
        }
    }

    private void addProgressBar() {
        this.progress = new JProgressBar(0, 10);
        this.progress.setToolTipText(Locale.LOCALE.get("ProgressToolTip"));
        this.add(this.progress);
        this.revalidate();
        this.repaint();
    }

    private void removeProgressBar() {
        this.remove(this.progress);
        this.progress = null;
        this.revalidate();
        this.repaint();
    }

    private void setFixedSize() {
        Dimension dim = new JProgressBar().getPreferredSize();
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
    }
}

