/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;

class ButtonFactory {
    ButtonFactory() {
    }

    static JButton createButtonByName(String name) {
        return ButtonFactory.createButtonByName(name, CoolButton.ButtonStyle.NORMAL);
    }

    static JButton createButtonByName(String name, CoolButton.ButtonStyle style) {
        CoolButton button = new CoolButton(style);
        Icon icon = ButtonFactory.getIconByName(name);
        if (icon != null) {
            ((AbstractButton)button).setIcon(icon);
        } else {
            ((AbstractButton)button).setText(name);
        }
        return button;
    }

    static JButton createButtonByText(String text) {
        CoolButton button = new CoolButton(CoolButton.ButtonStyle.NORMAL);
        ((AbstractButton)button).setText(text);
        return button;
    }

    static Icon getIconByName(String name, int size) {
        return IconFactory.createInvertedIcon(ButtonFactory.class, name + ".png", size);
    }

    static Icon getIconByName(String name) {
        return IconFactory.createInvertedIcon(ButtonFactory.class, name + ".png");
    }
}

