/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui;

import com.lightcrafts.model.EngineListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class ActivityMeter
extends JLayeredPane
implements EngineListener {
    public static final long WaitThreshold = 250L;
    private double avgTileWait;
    private long lastTileTime;
    private long doneTime;
    private BarDisplay progress;
    private JComponent underlay;

    public ActivityMeter(JComponent underlay) {
        this.underlay = underlay;
        this.progress = new BarDisplay();
        this.setLayout(null);
        this.add((Component)underlay, JLayeredPane.DEFAULT_LAYER);
        this.avgTileWait = 100.0;
        this.doneTime = this.lastTileTime = System.currentTimeMillis();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.underlay.getPreferredSize();
    }

    @Override
    public synchronized void engineActive(final int newValue) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActivityMeter.this.engineActive(newValue);
                }
            });
        }
        boolean isVisible = this.progress.getParent() != null;
        double oldValue = this.progress.getValue();
        long oldTime = this.lastTileTime;
        long newTime = System.currentTimeMillis();
        if ((double)newValue < oldValue) {
            double tileWait = (double)(newTime - oldTime) / (oldValue - (double)newValue);
            this.avgTileWait = (this.avgTileWait + tileWait) / 2.0;
        }
        this.lastTileTime = newTime;
        this.doneTime = Math.round((double)newTime + (double)newValue * this.avgTileWait);
        if (newValue > this.progress.getMaximum()) {
            this.progress.setMaximum(newValue);
        }
        this.progress.setValue(newValue);
        if (newValue > 0) {
            this.progress.setShowWait(null);
        }
        if (this.getTimeRemaining() >= 250L && !isVisible) {
            this.add((Component)this.progress, JLayeredPane.PALETTE_LAYER);
            this.doProgressLayout();
            this.progress.repaint();
        } else if (newValue == 0 && isVisible && this.progress.waitText == null) {
            this.remove(this.progress);
            this.repaint(this.progress.getBounds());
        }
    }

    public void showWait(String text) {
        boolean isVisible;
        this.progress.setShowWait(text);
        boolean bl = isVisible = this.progress.getParent() != null;
        if (!isVisible) {
            this.add((Component)this.progress, JLayeredPane.PALETTE_LAYER);
            this.doProgressLayout();
        }
        this.progress.repaint();
    }

    public void hideWait() {
        boolean isVisible;
        this.progress.setShowWait(null);
        boolean bl = isVisible = this.progress.getParent() != null;
        if (isVisible) {
            this.repaint(this.progress.getBounds());
            this.remove(this.progress);
        }
    }

    public long getTimeRemaining() {
        long remaining = this.doneTime - System.currentTimeMillis();
        return Math.max(remaining, 0L);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        this.underlay.setBounds(0, 0, size.width, size.height);
        this.doProgressLayout();
    }

    private void doProgressLayout() {
        Dimension size = this.getSize();
        int centerX = size.width / 2;
        int highY = (int)Math.round(0.1 * (double)size.height);
        Dimension displaySize = this.progress.getPreferredSize();
        int width = displaySize.width;
        int height = displaySize.height;
        this.progress.setBounds(centerX - width / 2, highY - height / 2, width, height);
    }

    class BarDisplay
    extends JComponent {
        private final Color FrameColor = new Color(200, 200, 200, 128);
        private final Color BackgroundColor = new Color(150, 150, 150, 128);
        private final Color ForegroundColor = new Color(255, 255, 255, 128);
        private static final int MaxBlocks = 7;
        private int min;
        private int max;
        private int value;
        private boolean showWait;
        private String waitText;

        BarDisplay() {
        }

        int getValue() {
            return this.value;
        }

        void setValue(int value) {
            int oldBlocks = this.getBlocks();
            this.value = value;
            if (this.getBlocks() != oldBlocks) {
                this.repaint();
            }
        }

        int getMinimum() {
            return this.min;
        }

        void setMinimum(int min) {
            this.min = min;
            this.repaint();
        }

        int getMaximum() {
            return this.max;
        }

        void setMaximum(int max) {
            this.max = max;
            this.repaint();
        }

        void setShowWait(String text) {
            this.showWait = text != null;
            this.waitText = text;
        }

        private int getBlocks() {
            return (int)Math.ceil((double)(7 * (this.value - this.min)) / (double)(this.max - this.min));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(90, 20);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            RenderingHints oldHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int diameter = 8;
            Dimension size = this.getSize();
            g.setColor(this.FrameColor);
            g.fillRoundRect(0, 0, size.width - 1, size.height - 1, diameter, diameter);
            g.setColor(this.BackgroundColor);
            g.fillRoundRect(1, 1, size.width - 2, size.height - 2, diameter, diameter);
            g.setRenderingHints(oldHints);
            if (this.showWait) {
                JLabel text = new JLabel(this.waitText);
                text.setForeground(this.ForegroundColor);
                text.setHorizontalAlignment(0);
                text.setSize(this.getSize());
                text.paint(graphics);
            } else {
                g.setColor(this.ForegroundColor);
                int count = 7 - this.getBlocks() + 1;
                for (int n = 0; n < count; ++n) {
                    this.drawOneRectangle(g, n);
                }
            }
        }

        private void drawOneRectangle(Graphics g, int n) {
            int inset = 4;
            Dimension size = this.getSize();
            int width = (size.width - 2 * inset) / 13;
            int left = 2 + inset + 2 * n * width;
            int right = 2 + inset + (2 * n + 1) * width;
            g.fillRoundRect(left, inset, right - left - 1, size.height - 2 * inset - 1, 4, 4);
        }
    }
}

