/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import Jama.Matrix;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileRGB;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class VibranceOpImage
extends PointOpImage {
    private final float[][] transform;
    private final boolean saturationIncrease;
    private final float[][] toLinearsRGB;

    public VibranceOpImage(RenderedImage source, float[][] transform, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        this.transform = transform;
        this.saturationIncrease = transform[0][0] > 1.0f;
        ICC_ProfileRGB linRGB = (ICC_ProfileRGB)ICC_Profile.getInstance(1004);
        this.toLinearsRGB = new Matrix(linRGB.getMatrix()).inverse().times(new Matrix(((ICC_ProfileRGB)JAIContext.linearProfile).getMatrix())).getArrayFloat();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dst.getDataType()) {
            case 1: {
                this.ushortLoop(src, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dst.getDataType());
            }
        }
    }

    static float arctan2(float y, float x) {
        float angle;
        float coeff_1 = 0.7853982f;
        float coeff_2 = 2.3561945f;
        float abs_y = Math.abs(y) + 1.0E-10f;
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = 0.7853982f - 0.7853982f * r;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = 2.3561945f - 0.7853982f * r;
        }
        return y < 0.0f ? -angle : angle;
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getShortDataArray(0);
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getShortDataArray(0);
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int srcPixOffset = srcPixelStride * col + row * srcLineStride;
                int r = 0xFFFF & srcData[srcPixOffset + srcROffset];
                int g = 0xFFFF & srcData[srcPixOffset + srcGOffset];
                int b = 0xFFFF & srcData[srcPixOffset + srcBOffset];
                float lr = this.toLinearsRGB[0][0] * (float)r + this.toLinearsRGB[0][1] * (float)g + this.toLinearsRGB[0][2] * (float)b;
                float lg = this.toLinearsRGB[1][0] * (float)r + this.toLinearsRGB[1][1] * (float)g + this.toLinearsRGB[1][2] * (float)b;
                float lb = this.toLinearsRGB[2][0] * (float)r + this.toLinearsRGB[2][1] * (float)g + this.toLinearsRGB[2][2] * (float)b;
                float x = lr - 0.5f * (lg + lb);
                float y = 0.866f * (lg - lb);
                float hue = (float)((double)VibranceOpImage.arctan2(x, y) + Math.PI);
                if (hue < 0.0f) {
                    hue = (float)((double)hue + Math.PI * 2);
                }
                if ((double)hue > 4.1887902047863905) {
                    hue = (float)((double)hue - 4.1887902047863905);
                } else if ((double)hue > 2.0943951023931953) {
                    hue = (float)((double)hue - 2.0943951023931953);
                }
                float mask = (float)(0.5 + 0.5 * (1.0 - Math.abs(0.5235987755982988 - (double)hue) / 1.0471975511965976));
                if (this.saturationIncrease) {
                    int min = Math.min(r, Math.min(g, b));
                    int max = Math.max(r, Math.max(g, b));
                    float saturation = max != 0 ? 1.0f - (float)min / (float)max : 0.0f;
                    mask *= 1.0f - saturation * saturation;
                }
                float rr = this.transform[0][0] * (float)r + this.transform[0][1] * (float)g + this.transform[0][2] * (float)b;
                float gg = this.transform[1][0] * (float)r + this.transform[1][1] * (float)g + this.transform[1][2] * (float)b;
                float bb = this.transform[2][0] * (float)r + this.transform[2][1] * (float)g + this.transform[2][2] * (float)b;
                rr = (1.0f - mask) * (float)r + rr * mask;
                gg = (1.0f - mask) * (float)g + gg * mask;
                bb = (1.0f - mask) * (float)b + bb * mask;
                int dstPixOffset = dstPixelStride * col + row * dstLineStride;
                dstData[dstPixOffset + dstROffset] = (short)(rr < 0.0f ? 0.0f : (rr > 65535.0f ? 65535.0f : rr));
                dstData[dstPixOffset + dstGOffset] = (short)(gg < 0.0f ? 0.0f : (gg > 65535.0f ? 65535.0f : gg));
                dstData[dstPixOffset + dstBOffset] = (short)(bb < 0.0f ? 0.0f : (bb > 65535.0f ? 65535.0f : bb));
            }
        }
    }
}

