/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.LCROIShape;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.TiledImage;
import com.lightcrafts.model.Contour;
import com.lightcrafts.model.Region;
import com.lightcrafts.utils.SoftValueHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class ShapedMask
extends PlanarImage {
    private Region region;
    private LCROIShape shape;
    private static Map<Contour, ScaledImage> bitmaps = Collections.synchronizedMap(new WeakHashMap());
    private static BorderExtender extender = BorderExtender.createInstance((int)1);
    private static final Map<AffinedImage, PlanarImage> expandedMasks = new SoftValueHashMap<AffinedImage, PlanarImage>();

    public static Rectangle getOuterBounds(Region region, AffineTransform transform) {
        Rectangle outerBounds = null;
        Iterator<Contour> i$ = region.getContours().iterator();
        while (i$.hasNext()) {
            Contour o;
            Contour c = o = i$.next();
            AffineTransform combined = transform;
            if (c.getTranslation() != null) {
                combined = AffineTransform.getTranslateInstance(c.getTranslation().getX(), c.getTranslation().getY());
                combined.preConcatenate(transform);
            }
            Rectangle cBounds = new Rectangle(c.getOuterShape().getBounds());
            cBounds = combined.createTransformedShape(cBounds).getBounds();
            if (outerBounds == null) {
                outerBounds = cBounds;
                continue;
            }
            outerBounds = outerBounds.union(cBounds);
        }
        return outerBounds;
    }

    private static ImageLayout createLayout(Region region, AffineTransform transform) {
        Rectangle regionBounds = ShapedMask.getOuterBounds(region, transform);
        SampleModel graySm = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)regionBounds.width, (int)regionBounds.height, (int)1);
        ComponentColorModel grayCm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        return new ImageLayout(regionBounds.x, regionBounds.y, regionBounds.width, regionBounds.height, regionBounds.x, regionBounds.y, 512, 512, graySm, (ColorModel)grayCm);
    }

    static ImageLayout createLayout(Rectangle regionBounds) {
        SampleModel graySm = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)regionBounds.width, (int)regionBounds.height, (int)1);
        ComponentColorModel grayCm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        return new ImageLayout(regionBounds.x, regionBounds.y, regionBounds.width, regionBounds.height, regionBounds.x, regionBounds.y, 512, 512, graySm, (ColorModel)grayCm);
    }

    public ShapedMask(Region region, LCROIShape shape) {
        super(ShapedMask.createLayout(region, shape.getTransform()), null, null);
        this.region = region;
        this.shape = shape;
    }

    private static Shape[] createBlurs(Shape shape, int width) {
        LinkedList<Shape> blurs = new LinkedList<Shape>();
        do {
            BasicStroke stroke = new BasicStroke(2 * width, 1, 1);
            Shape blur = stroke.createStrokedShape(shape);
            blurs.add(blur);
        } while ((width /= 2) > 0);
        int size = blurs.size();
        Shape[] result = new Shape[size];
        Iterator it = blurs.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[size - 1 - i++] = (Shape)it.next();
        }
        return result;
    }

    private static void drawBlurs(Graphics2D g2d, Shape shape, float contourWidth) {
        g2d.setColor(Color.white);
        g2d.fill(shape);
        if (contourWidth <= 1.0f) {
            return;
        }
        int width = Math.round(contourWidth);
        Shape[] blurs = ShapedMask.createBlurs(shape, width);
        int count = blurs.length;
        Area shapeArea = new Area(shape);
        for (int n = count - 1; n >= 0; --n) {
            Shape blur = blurs[n];
            Area semiBlur = new Area(blur);
            semiBlur.intersect(shapeArea);
            float value = (float)n / (float)(count + 1);
            Color color = new Color(value, value, value);
            g2d.setColor(color);
            g2d.fill(semiBlur);
        }
    }

    private static ScaledImage createContourImage(Contour contour) {
        Shape shape = contour.getOuterShape();
        float contourWidth = contour.getWidth();
        float widthScale = 1.0f;
        int divideByTwo = 1;
        while (contourWidth > 28.0f) {
            contourWidth /= 2.0f;
            widthScale /= 2.0f;
            divideByTwo *= 2;
        }
        if (widthScale < 1.0f) {
            shape = AffineTransform.getScaleInstance(widthScale, widthScale).createTransformedShape(shape);
        }
        Rectangle bounds = shape.getBounds();
        bounds.grow((int)contourWidth, (int)contourWidth);
        BufferedImage supportImage = new BufferedImage(bounds.width, bounds.height, 10);
        Graphics2D g2d = supportImage.createGraphics();
        g2d.setTransform(AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
        ShapedMask.drawBlurs(g2d, shape, contourWidth);
        g2d.dispose();
        supportImage = new TiledImage((RenderedImage)supportImage, Math.max(512 / divideByTwo, 8), Math.max(512 / divideByTwo, 8));
        ScaledImage contourImage = new ScaledImage();
        if (contourWidth > 1.0f) {
            KernelJAI kernel = Functions.getGaussKernel(contourWidth / 4.0f);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(supportImage);
            pb.add(kernel);
            RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
            contourImage.image = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)hints);
        } else {
            contourImage.image = (PlanarImage)supportImage;
        }
        contourImage.scale = widthScale;
        contourImage.tx = bounds.x;
        contourImage.ty = bounds.y;
        return contourImage;
    }

    private static synchronized ScaledImage getContourImage(Contour contour) {
        ScaledImage contourImage = bitmaps.get(contour);
        if (contourImage == null && (contourImage = bitmaps.get(contour)) == null) {
            contourImage = ShapedMask.createContourImage(contour);
            bitmaps.put(contour, contourImage);
        }
        return contourImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster getData(Rectangle rect) {
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(rect.width, rect.height);
        TiledImage ti = new TiledImage(rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, sampleModel, (ColorModel)colorModel);
        WritableRaster result = (WritableRaster)ti.getData();
        boolean overlay = false;
        for (Contour c : this.region.getContours()) {
            byte[] resultData;
            AffineTransform combined = this.shape.getTransform();
            if (c.getTranslation() != null) {
                combined = AffineTransform.getTranslateInstance(c.getTranslation().getX(), c.getTranslation().getY());
                combined.preConcatenate(this.shape.getTransform());
            }
            Rectangle bounds = c.getOuterShape().getBounds();
            bounds.grow((int)c.getWidth(), (int)c.getWidth());
            if (!combined.createTransformedShape(bounds).intersects(rect)) continue;
            ScaledImage scaledImage = ShapedMask.getContourImage(c);
            PlanarImage maskImage = scaledImage.image;
            if (!combined.isIdentity() || scaledImage.scale < 1.0f || scaledImage.tx != 0.0f || scaledImage.ty != 0.0f) {
                AffineTransform transform = new AffineTransform(combined);
                if (scaledImage.scale < 1.0f) {
                    float scaleX = (float)Math.floor((float)maskImage.getWidth() / scaledImage.scale) / (float)maskImage.getWidth();
                    float scaleY = (float)Math.floor((float)maskImage.getHeight() / scaledImage.scale) / (float)maskImage.getHeight();
                    transform.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
                }
                if (scaledImage.tx != 0.0f || scaledImage.ty != 0.0f) {
                    transform.concatenate(AffineTransform.getTranslateInstance(scaledImage.tx, scaledImage.ty));
                }
                Rectangle scaledBounds = transform.createTransformedShape(maskImage.getBounds()).getBounds();
                if (scaledBounds.width < 3 || scaledBounds.height < 3) continue;
                Map<AffinedImage, PlanarImage> scaleY = expandedMasks;
                synchronized (scaleY) {
                    AffinedImage key = new AffinedImage(maskImage, transform);
                    PlanarImage affinedImage = expandedMasks.get(key);
                    if (affinedImage == null) {
                        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                        Interpolation interp = Interpolation.getInstance((int)1);
                        ParameterBlock params = new ParameterBlock();
                        params.addSource(maskImage);
                        params.add(transform);
                        params.add(interp);
                        maskImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)hints);
                        expandedMasks.put(key, maskImage);
                    } else {
                        maskImage = affinedImage;
                    }
                }
            }
            if (!maskImage.getBounds().intersects(rect)) continue;
            Rectangle itx = maskImage.getBounds().intersection(rect);
            if (!overlay) {
                resultData = (byte[])maskImage.getData(itx).getDataElements(itx.x, itx.y, itx.width, itx.height, null);
                overlay = true;
            } else {
                resultData = (byte[])result.getDataElements(itx.x, itx.y, itx.width, itx.height, null);
                byte[] currentData = (byte[])maskImage.getData(itx).getDataElements(itx.x, itx.y, itx.width, itx.height, null);
                for (int i = 0; i < resultData.length; ++i) {
                    int current = currentData[i] & 0xFF;
                    if (current == 0) continue;
                    int cumulative = resultData[i] & 0xFF;
                    resultData[i] = cumulative != 0 ? (byte)(cumulative * (255 - current) / 256 + current) : (byte)current;
                }
            }
            result.setDataElements(itx.x, itx.y, itx.width, itx.height, resultData);
        }
        return result;
    }

    public Raster getTile(int tileX, int tileY) {
        return this.getData(new Rectangle(this.tileXToX(tileX), this.tileYToY(tileY), this.getTileWidth(), this.getTileHeight()));
    }

    private static class AffinedImage {
        PlanarImage image;
        AffineTransform transform;

        AffinedImage(PlanarImage image, AffineTransform transform) {
            this.image = image;
            this.transform = transform;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AffinedImage)) {
                return false;
            }
            AffinedImage affinedImage = (AffinedImage)o;
            if (this.image != null ? !this.image.equals(affinedImage.image) : affinedImage.image != null) {
                return false;
            }
            return !(this.transform != null ? !this.transform.equals(affinedImage.transform) : affinedImage.transform != null);
        }

        public int hashCode() {
            int result = this.image != null ? this.image.hashCode() : 0;
            result = 29 * result + (this.transform != null ? this.transform.hashCode() : 0);
            return result;
        }
    }

    static class RasterImage
    extends PlanarImage {
        private Raster raster;

        RasterImage(Raster r, ColorModel colorModel) {
            super(new ImageLayout(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight(), r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight(), r.getSampleModel(), colorModel), null, null);
            this.raster = r;
        }

        public Raster getTile(int tileX, int tileY) {
            return this.raster;
        }
    }

    private static class ScaledImage {
        float scale = 1.0f;
        float tx = 0.0f;
        float ty = 0.0f;
        PlanarImage image = null;

        private ScaledImage() {
        }
    }
}

