/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.media.jai.util.JDKWorkarounds;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

final class MultiplyAddOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;
    protected double[] constants;

    public MultiplyAddOpImage(RenderedImage source1, RenderedImage source2, Map config, ImageLayout layout, double[] constants) {
        super(source1, source2, layout, config, true);
        SampleModel sm;
        int numBandsDst;
        int numBands1 = source1.getSampleModel().getNumBands();
        int numBands2 = source2.getSampleModel().getNumBands();
        if (layout != null && layout.isValid(256) && (numBandsDst = (sm = layout.getSampleModel(null)).getNumBands()) > 1 && (numBands1 == 1 && numBands2 > 1 || numBands2 == 1 && numBands1 > 1)) {
            numBandsDst = Math.min(Math.max(numBands1, numBands2), numBandsDst);
            if (numBandsDst != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel((SampleModel)sm, (int)this.sampleModel.getTransferType(), (int)this.sampleModel.getWidth(), (int)this.sampleModel.getHeight(), (int)numBandsDst);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)this.sampleModel, (ColorModel)this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel((SampleModel)this.sampleModel, (Map)config);
                }
            }
            if (constants.length < numBandsDst) {
                this.constants = new double[numBandsDst];
                for (int i = 0; i < numBandsDst; ++i) {
                    this.constants[i] = constants[0];
                }
            } else {
                this.constants = (double[])constants.clone();
            }
            this.s1bd = numBands1 == 1 ? 0 : 1;
            this.s2bd = numBands2 == 1 ? 0 : 1;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        switch (d.getDataType()) {
            case 0: {
                this.computeRectByte(s1, s2, d);
                break;
            }
            case 1: {
                this.computeRectUShort(s1, s2, d);
                break;
            }
            case 2: {
                this.computeRectShort(s1, s2, d);
                break;
            }
            case 3: {
                this.computeRectInt(s1, s2, d);
                break;
            }
            case 4: {
                this.computeRectFloat(s1, s2, d);
                break;
            }
            case 5: {
                this.computeRectDouble(s1, s2, d);
            }
        }
        if (d.needsClamping()) {
            d.clampDataArrays();
        }
        d.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        byte[][] s1Data = src1.getByteDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        byte[][] s2Data = src2.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        int b = 0;
        int s1b = 0;
        int s2b = 0;
        while (b < bands) {
            byte[] s1 = s1Data[s1b];
            byte[] s2 = s2Data[s2b];
            byte[] d = dData[b];
            double c = this.constants[b];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b];
            for (int h = 0; h < dheight; ++h) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d[dPixelOffset] = ImageUtil.clampRoundByte((double)((double)(s1[s1PixelOffset] & 0xFF) + c * (double)(s2[s2PixelOffset] & 0xFF)));
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectUShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int b = 0;
        int s1b = 0;
        int s2b = 0;
        while (b < bands) {
            short[] s1 = s1Data[s1b];
            short[] s2 = s2Data[s2b];
            short[] d = dData[b];
            double c = this.constants[b];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b];
            for (int h = 0; h < dheight; ++h) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d[dPixelOffset] = ImageUtil.clampRoundUShort((double)((double)(s1[s1PixelOffset] & 0xFFFF) + c * (double)(s2[s2PixelOffset] & 0xFFFF)));
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int b = 0;
        int s1b = 0;
        int s2b = 0;
        while (b < bands) {
            short[] s1 = s1Data[s1b];
            short[] s2 = s2Data[s2b];
            short[] d = dData[b];
            double c = this.constants[b];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b];
            for (int h = 0; h < dheight; ++h) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d[dPixelOffset] = ImageUtil.clampRoundShort((double)((double)s1[s1PixelOffset] + c * (double)s2[s2PixelOffset]));
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectInt(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        int[][] s1Data = src1.getIntDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        int[][] s2Data = src2.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int b = 0;
                int s1b = 0;
                int s2b = 0;
                while (b < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d = dData[b];
                    double c = this.constants[b];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b];
                    for (int h = 0; h < dheight; ++h) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d[dPixelOffset] = ImageUtil.clampRoundByte((double)((double)(s1[s1PixelOffset] & 0xFF) + c * (double)(s2[s2PixelOffset] & 0xFF)));
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 1: {
                int b = 0;
                int s1b = 0;
                int s2b = 0;
                while (b < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d = dData[b];
                    double c = this.constants[b];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b];
                    for (int h = 0; h < dheight; ++h) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d[dPixelOffset] = ImageUtil.clampRoundUShort((double)((double)(s1[s1PixelOffset] & 0xFFFF) + c * (double)(s2[s2PixelOffset] & 0xFFFF)));
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 2: {
                int b = 0;
                int s1b = 0;
                int s2b = 0;
                while (b < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d = dData[b];
                    double c = this.constants[b];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b];
                    for (int h = 0; h < dheight; ++h) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d[dPixelOffset] = ImageUtil.clampRoundShort((double)((double)s1[s1PixelOffset] + c * (double)s2[s2PixelOffset]));
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 3: {
                int b = 0;
                int s1b = 0;
                int s2b = 0;
                while (b < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d = dData[b];
                    double c = this.constants[b];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b];
                    for (int h = 0; h < dheight; ++h) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d[dPixelOffset] = ImageUtil.clampRoundInt((double)((double)s1[s1PixelOffset] + c * (double)s2[s2PixelOffset]));
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
        }
    }

    private void computeRectFloat(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        float[][] s1Data = src1.getFloatDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        float[][] s2Data = src2.getFloatDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        int b = 0;
        int s1b = 0;
        int s2b = 0;
        while (b < bands) {
            float[] s1 = s1Data[s1b];
            float[] s2 = s2Data[s2b];
            float[] d = dData[b];
            float c = (float)this.constants[b];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b];
            for (int h = 0; h < dheight; ++h) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d[dPixelOffset] = s1[s1PixelOffset] + c * s2[s2PixelOffset];
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectDouble(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        double[][] s1Data = src1.getDoubleDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        double[][] s2Data = src2.getDoubleDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        int b = 0;
        int s1b = 0;
        int s2b = 0;
        while (b < bands) {
            double[] s1 = s1Data[s1b];
            double[] s2 = s2Data[s2b];
            double[] d = dData[b];
            double c = this.constants[b];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b];
            for (int h = 0; h < dheight; ++h) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d[dPixelOffset] = s1[s1PixelOffset] + c * s2[s2PixelOffset];
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }
}

