/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import Jama.Matrix;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileRGB;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class IntVibranceOpImage
extends PointOpImage {
    private final int[][] transform = new int[3][3];
    private final int[][] toLinearsRGB = new int[3][3];
    private final boolean saturationIncrease;
    private static final int sMath_scale = 32768;
    private static final int sMath_PI = 102943;

    static int arctan2(int y, int x) {
        int angle;
        int coeff_1 = 25735;
        int coeff_2 = 77205;
        int abs_y = Math.abs(y) + 1;
        if (x >= 0) {
            int r = 32768 * (x - abs_y) / (x + abs_y);
            angle = 25735 - 25735 * r / 32768;
        } else {
            int r = 32768 * (x + abs_y) / (abs_y - x);
            angle = 77205 - 25735 * r / 32768;
        }
        return y < 0 ? -angle : angle;
    }

    public IntVibranceOpImage(RenderedImage source, float[][] transform, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.transform[i][j] = (int)(32768.0f * transform[i][j]);
            }
        }
        this.saturationIncrease = transform[0][0] > 1.0f;
        ICC_ProfileRGB linRGB = (ICC_ProfileRGB)ICC_Profile.getInstance(1004);
        Matrix XYZtoLinsRGB = new Matrix(linRGB.getMatrix()).inverse();
        Matrix CIERGBtoXYZ = new Matrix(((ICC_ProfileRGB)JAIContext.linearProfile).getMatrix());
        double[][] CIERGBtoLinsRGB = XYZtoLinsRGB.times(CIERGBtoXYZ).getArray();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.toLinearsRGB[i][j] = (int)(32768.0 * CIERGBtoLinsRGB[i][j]);
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dst.getDataType()) {
            case 1: {
                this.ushortLoop(src, dst);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dst.getDataType());
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getShortDataArray(0);
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getShortDataArray(0);
        int[] srcBandOffsets = src.getBandOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        int sqrt3d2 = (int)(32768.0 * Math.sqrt(3.0) / 2.0);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int srcPixOffset = srcPixelStride * col + row * srcLineStride;
                int r = (0xFFFF & srcData[srcPixOffset + srcROffset]) / 2;
                int g = (0xFFFF & srcData[srcPixOffset + srcGOffset]) / 2;
                int b = (0xFFFF & srcData[srcPixOffset + srcBOffset]) / 2;
                int lr = (this.toLinearsRGB[0][0] * r + this.toLinearsRGB[0][1] * g + this.toLinearsRGB[0][2] * b) / 32768;
                int lg = (this.toLinearsRGB[1][0] * r + this.toLinearsRGB[1][1] * g + this.toLinearsRGB[1][2] * b) / 32768;
                int lb = (this.toLinearsRGB[2][0] * r + this.toLinearsRGB[2][1] * g + this.toLinearsRGB[2][2] * b) / 32768;
                int x = lr - (lg + lb) / 2;
                int y = sqrt3d2 * (lg - lb) / 32768;
                int hue = IntVibranceOpImage.arctan2(x, y) + 102943;
                if (hue < 0) {
                    hue += 205886;
                }
                if (hue > 137257) {
                    hue -= 137257;
                } else if (hue > 68628) {
                    hue -= 68628;
                }
                int mask = 16384 + (32768 - 32768 * Math.abs(17157 - hue) / 34314) / 2;
                if (this.saturationIncrease) {
                    int min = Math.min(r, Math.min(g, b));
                    int max = Math.max(r, Math.max(g, b));
                    int saturation = max != 0 ? 32768 - 32768 * min / max : 0;
                    mask = mask * (32768 - saturation * saturation / 32768) / 32768;
                }
                int rr = (this.transform[0][0] * r + this.transform[0][1] * g + this.transform[0][2] * b) / 32768;
                int gg = (this.transform[1][0] * r + this.transform[1][1] * g + this.transform[1][2] * b) / 32768;
                int bb = (this.transform[2][0] * r + this.transform[2][1] * g + this.transform[2][2] * b) / 32768;
                rr = 2 * ((32768 - mask) * r / 32768 + rr * mask / 32768);
                gg = 2 * ((32768 - mask) * g / 32768 + gg * mask / 32768);
                bb = 2 * ((32768 - mask) * b / 32768 + bb * mask / 32768);
                int dstPixOffset = dstPixelStride * col + row * dstLineStride;
                dstData[dstPixOffset + dstROffset] = (short)(rr < 0 ? 0 : (rr > 65535 ? 65535 : rr));
                dstData[dstPixOffset + dstGOffset] = (short)(gg < 0 ? 0 : (gg > 65535 ? 65535 : gg));
                dstData[dstPixOffset + dstBOffset] = (short)(bb < 0 ? 0 : (bb > 65535 ? 65535 : bb));
            }
        }
    }
}

