/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai;

import com.lightcrafts.jai.operator.BilateralFilterDescriptor;
import com.lightcrafts.jai.operator.BlendDescriptor;
import com.lightcrafts.jai.operator.LCBandCombineDescriptor;
import com.lightcrafts.jai.operator.LCColorConvertDescriptor;
import com.lightcrafts.jai.operator.LCErodeDescriptor;
import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.jai.operator.LCSeparableConvolveDescriptor;
import com.lightcrafts.jai.operator.NOPDescriptor;
import com.lightcrafts.jai.operator.RawAdjustmentsDescriptor;
import com.lightcrafts.jai.operator.UnSharpMaskDescriptor;
import com.lightcrafts.jai.opimage.BilateralFilterRIF;
import com.lightcrafts.jai.opimage.BlendCRIF;
import com.lightcrafts.jai.opimage.LCBandCombineCRIF;
import com.lightcrafts.jai.opimage.LCColorConvertCRIF;
import com.lightcrafts.jai.opimage.LCErodeRIF;
import com.lightcrafts.jai.opimage.LCMSColorConvertCRIF;
import com.lightcrafts.jai.opimage.LCSeparableConvolveRIF;
import com.lightcrafts.jai.opimage.NOPCRIF;
import com.lightcrafts.jai.opimage.RawAdjustmentsCRIF;
import com.lightcrafts.jai.opimage.UnSharpMaskCRIF;
import com.lightcrafts.jai.utils.LCRecyclingTileFactory;
import com.lightcrafts.jai.utils.LCTileCache;
import com.lightcrafts.media.jai.util.SunTileCache;
import com.lightcrafts.mediax.jai.CRIFImpl;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.OperationRegistry;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RegistryElementDescriptor;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.mediax.jai.registry.CRIFRegistry;
import com.lightcrafts.mediax.jai.registry.RIFRegistry;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.ColorScience;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public class JAIContext {
    public static final Collection<ColorProfileInfo> systemProfiles;
    public static final ICC_Profile linearProfile;
    public static final ICC_ColorSpace linearColorSpace;
    public static final ICC_Profile labProfile;
    public static final ICC_ColorSpace labColorSpace;
    public static final ICC_Profile gray22Profile;
    public static final ICC_ColorSpace gray22ColorSpace;
    public static final ICC_Profile oldLinearProfile;
    public static final ICC_ColorSpace oldLinearColorSpace;
    public static final ICC_Profile CMYKProfile;
    public static final ICC_ColorSpace CMYKColorSpace;
    public static final ICC_Profile systemProfile;
    public static final ColorSpace systemColorSpace;
    public static final ICC_ColorSpace linearGrayColorSpace;
    public static final ICC_ColorSpace sRGBColorSpace;
    public static final ICC_Profile sRGBColorProfile;
    public static final ICC_Profile sRGBExportColorProfile;
    public static final ICC_Profile adobeRGBProfile;
    public static final ColorSpace adobeRGBColorSpace;
    public static final ColorModel colorModel_linear16;
    public static final ColorModel colorModel_linear8;
    public static final ColorModel colorModel_sRGB16;
    public static final ColorModel colorModel_sRGB8;
    public static final ColorModel systemColorModel;
    public static final RenderingHints noCacheHint;
    public static final String PERSISTENT_CACHE_TAG = "LCPersistentCache";
    public static final TileCache noTileCache;
    public static final RenderingHints fileCacheHint;
    public static final TileCache fileCache;
    public static final TileCache defaultTileCache;
    public static final int TILE_WIDTH = 512;
    public static final int TILE_HEIGHT = 512;

    static void dumpProperty(ICC_Profile profile, int tag, String name) {
        byte[] data = profile.getData(tag);
        if (data != null) {
            System.out.print(name + " (" + data.length + ") :");
            for (byte aData : data) {
                System.out.print(" " + (aData & 0xFF));
            }
            System.out.println();
            for (byte aData : data) {
                System.out.print((char)(aData & 0xFF));
            }
            System.out.println();
        } else {
            System.out.println("no " + name + " info");
        }
    }

    public static ColorModel getColorModelFrom(ColorSpace colorSpace, Raster raster) {
        return new ComponentColorModel(colorSpace, false, false, 1, raster.getSampleModel().getDataType());
    }

    public static ColorModel getColorModelFrom(ICC_Profile profile, Raster raster) {
        return JAIContext.getColorModelFrom(JAIContext.getColorSpaceFrom(profile, raster), raster);
    }

    public static ColorSpace getColorSpaceFrom(ICC_Profile profile, Raster raster) {
        if (profile != null) {
            return new ICC_ColorSpace(profile);
        }
        switch (raster.getSampleModel().getNumBands()) {
            case 1: {
                return gray22ColorSpace;
            }
            case 3: {
                return sRGBColorSpace;
            }
            case 4: {
                return CMYKColorSpace;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zlum(ICC_ColorSpace cs) {
        Class<ColorSpace> clazz = ColorSpace.class;
        synchronized (ColorSpace.class) {
            float[] zero = cs.fromCIEXYZ(new float[]{0.0f, 0.0f, 0.0f});
            // ** MonitorExit[var2_1] (shouldn't be in output)
            System.out.println("zero: " + zero[0] + " : " + zero[1] + " : " + zero[2]);
            double zlum = ColorScience.Wr * zero[0] + ColorScience.Wg * zero[1] + ColorScience.Wb * zero[2];
            System.out.println("zero lum: " + zlum);
            return;
        }
    }

    static {
        RenderingHints _noCacheHint;
        ICC_Profile _systemProfile;
        ComponentColorModel _systemColorModel;
        ICC_ColorSpace _systemColorSpace;
        ComponentColorModel _colorModel_sRGB8;
        ComponentColorModel _colorModel_sRGB16;
        ComponentColorModel _colorModel_linear8;
        ComponentColorModel _colorModel_linear16;
        ICC_ColorSpace _adobeRGBColorSpace;
        ICC_Profile _adobeRGBProfile;
        ICC_ColorSpace _gray22ColorSpace;
        ICC_Profile _gray22Profile;
        ICC_ColorSpace _labColorSpace;
        ICC_Profile _labProfile;
        ICC_ColorSpace _CMYKColorSpace;
        ICC_Profile _CMYKProfile;
        ICC_ColorSpace _oldLinearColorSpace;
        ICC_Profile _oldLinearProfile;
        ICC_ColorSpace _linearColorSpace;
        ICC_Profile _linearProfile;
        Collection<ColorProfileInfo> printerProfiles;
        linearGrayColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        noTileCache = new SunTileCache(0L);
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.printf("Max Memory:   %11d%n", maxMemory);
        System.out.printf("Total Memory: %11d%n", Runtime.getRuntime().totalMemory());
        JAI jaiInstance = JAI.getDefaultInstance();
        int processors = Runtime.getRuntime().availableProcessors();
        String[] VMVersion = System.getProperty("java.version").split("[._]");
        String OSArch = System.getProperty("os.arch");
        System.out.println("Running on " + processors + " processors");
        if (OSArch.equals("ppc") && Integer.parseInt(VMVersion[3]) < 7) {
            processors = Math.min(processors, 2);
            System.out.println("Old PPC Java, limiting to " + processors + " processors");
        }
        int MB = 0x100000;
        if (maxMemory >= 0x19000000L) {
            jaiInstance.getTileScheduler().setParallelism(processors);
        } else {
            jaiInstance.getTileScheduler().setParallelism(1);
        }
        fileCache = new LCTileCache(maxMemory <= 0x40000000L ? maxMemory / 2L : maxMemory - 0x20000000L, true);
        jaiInstance.setTileCache(fileCache);
        fileCacheHint = new RenderingHints(JAI.KEY_TILE_CACHE, fileCache);
        defaultTileCache = jaiInstance.getTileCache();
        LCRecyclingTileFactory rtf = new LCRecyclingTileFactory();
        jaiInstance.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)rtf);
        jaiInstance.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)rtf);
        OperationRegistry or = jaiInstance.getOperationRegistry();
        OperationDescriptorImpl desc = new LCColorConvertDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        CRIFImpl crif = new LCColorConvertCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)crif);
        CRIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (ContextualRenderedImageFactory)crif);
        desc = new LCMSColorConvertDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        crif = new LCMSColorConvertCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)crif);
        CRIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (ContextualRenderedImageFactory)crif);
        desc = new BlendDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        crif = new BlendCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)crif);
        CRIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (ContextualRenderedImageFactory)crif);
        desc = new LCSeparableConvolveDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        Object rif = new LCSeparableConvolveRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)rif);
        desc = new NOPDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        crif = new NOPCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)crif);
        CRIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (ContextualRenderedImageFactory)crif);
        desc = new UnSharpMaskDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        crif = new UnSharpMaskCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)crif);
        CRIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (ContextualRenderedImageFactory)crif);
        desc = new LCErodeDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        rif = new LCErodeRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)rif);
        desc = new RawAdjustmentsDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        rif = new RawAdjustmentsCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)rif);
        desc = new LCBandCombineDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        rif = new LCBandCombineCRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)rif);
        desc = new BilateralFilterDescriptor();
        or.registerDescriptor((RegistryElementDescriptor)desc);
        rif = new BilateralFilterRIF();
        RIFRegistry.register((OperationRegistry)or, (String)desc.getName(), (String)"com.lightcrafts", (RenderedImageFactory)rif);
        JAI.setDefaultTileSize((Dimension)new Dimension(512, 512));
        systemProfiles = new ArrayList<ColorProfileInfo>();
        Collection<ColorProfileInfo> exportProfiles = Platform.getPlatform().getExportProfiles();
        if (exportProfiles != null) {
            systemProfiles.addAll(exportProfiles);
        }
        if ((printerProfiles = Platform.getPlatform().getPrinterProfiles()) != null) {
            systemProfiles.addAll(printerProfiles);
        }
        ICC_Profile _sRGBColorProfile = null;
        for (ColorProfileInfo cpi : systemProfiles) {
            if (!cpi.getName().equals("sRGB Profile") && !cpi.getName().equals("sRGB IEC61966-2.1")) continue;
            try {
                _sRGBColorProfile = ICC_Profile.getInstance(cpi.getPath());
                System.out.println("found " + cpi.getName());
                if (_sRGBColorProfile == null) continue;
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (_sRGBColorProfile == null) {
            InputStream in = JAIContext.class.getResourceAsStream("resources/sRGB.icc");
            try {
                _sRGBColorProfile = ICC_Profile.getInstance(in);
            }
            catch (IOException e) {
                System.err.println("Can't load resource sRGB profile, defaulting on Java's");
                _sRGBColorProfile = ICC_Profile.getInstance(1000);
            }
        }
        sRGBExportColorProfile = _sRGBColorProfile;
        sRGBColorProfile = ICC_Profile.getInstance(1000);
        sRGBColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        try {
            InputStream in = JAIContext.class.getResourceAsStream("resources/rimm.icm");
            _linearProfile = ICC_Profile.getInstance(in);
            _linearColorSpace = new ICC_ColorSpace(_linearProfile);
            in = JAIContext.class.getResourceAsStream("resources/CIE 1931 D50 Gamma 1.icm");
            _oldLinearProfile = ICC_Profile.getInstance(in);
            _oldLinearColorSpace = new ICC_ColorSpace(_linearProfile);
            in = JAIContext.class.getResourceAsStream("resources/Generic CMYK Profile.icc");
            _CMYKProfile = ICC_Profile.getInstance(in);
            _CMYKColorSpace = new ICC_ColorSpace(_CMYKProfile);
            in = JAIContext.class.getResourceAsStream("resources/Generic Lab Profile.icm");
            _labProfile = ICC_Profile.getInstance(in);
            _labColorSpace = new ICC_ColorSpace(_labProfile);
            in = JAIContext.class.getResourceAsStream("resources/Gray Gamma 2.2.icc");
            _gray22Profile = ICC_Profile.getInstance(in);
            _gray22ColorSpace = new ICC_ColorSpace(_gray22Profile);
            in = JAIContext.class.getResourceAsStream("resources/compatibleWithAdobeRGB1998.icc");
            _adobeRGBProfile = ICC_Profile.getInstance(in);
            _adobeRGBColorSpace = new ICC_ColorSpace(_adobeRGBProfile);
            _colorModel_linear16 = RasterFactory.createComponentColorModel((int)1, (ColorSpace)_linearColorSpace, (boolean)false, (boolean)false, (int)1);
            _colorModel_linear8 = RasterFactory.createComponentColorModel((int)0, (ColorSpace)_linearColorSpace, (boolean)false, (boolean)false, (int)1);
            _colorModel_sRGB16 = RasterFactory.createComponentColorModel((int)1, (ColorSpace)sRGBColorSpace, (boolean)false, (boolean)false, (int)1);
            _colorModel_sRGB8 = RasterFactory.createComponentColorModel((int)0, (ColorSpace)sRGBColorSpace, (boolean)false, (boolean)false, (int)1);
            _systemColorSpace = sRGBColorSpace;
            _systemColorModel = _colorModel_sRGB8;
            _systemProfile = _sRGBColorProfile;
            try {
                ICC_Profile displayProfile = Platform.getPlatform().getDisplayProfile();
                if (displayProfile != null) {
                    _systemProfile = displayProfile;
                    _systemColorSpace = new ICC_ColorSpace(_systemProfile);
                    _systemColorModel = RasterFactory.createComponentColorModel((int)0, (ColorSpace)_systemColorSpace, (boolean)false, (boolean)false, (int)1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            _noCacheHint = new RenderingHints(JAI.KEY_TILE_CACHE, noTileCache);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't access color space resource", e);
        }
        linearProfile = _linearProfile;
        linearColorSpace = _linearColorSpace;
        oldLinearProfile = _oldLinearProfile;
        oldLinearColorSpace = _oldLinearColorSpace;
        colorModel_linear16 = _colorModel_linear16;
        colorModel_linear8 = _colorModel_linear8;
        colorModel_sRGB16 = _colorModel_sRGB16;
        colorModel_sRGB8 = _colorModel_sRGB8;
        CMYKProfile = _CMYKProfile;
        CMYKColorSpace = _CMYKColorSpace;
        labProfile = _labProfile;
        labColorSpace = _labColorSpace;
        gray22Profile = _gray22Profile;
        gray22ColorSpace = _gray22ColorSpace;
        adobeRGBProfile = _adobeRGBProfile;
        adobeRGBColorSpace = _adobeRGBColorSpace;
        systemProfile = _systemProfile;
        systemColorSpace = _systemColorSpace;
        systemColorModel = _systemColorModel;
        noCacheHint = _noCacheHint;
    }
}

