/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCTIFFReader;
import com.lightcrafts.image.libs.LCTIFFWriter;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.DCRaw;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;

class RawImageCache
extends Thread {
    private static String version = "V5";
    private static final RawImageCache INSTANCE = new RawImageCache();
    private ImageToCache currentJob;

    private RawImageCache() {
        super("RawImageCache");
        this.setPriority(4);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(String cacheKey, RenderedImage rawImage) {
        RawImageCache rawImageCache = INSTANCE;
        synchronized (rawImageCache) {
            RawImageCache.INSTANCE.currentJob = new ImageToCache(cacheKey, rawImage);
            INSTANCE.notify();
        }
    }

    static String getCacheKeyFor(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        Date captureDate = metadata.getCaptureDateTime();
        if (captureDate == null) {
            RawImageInfo rawInfo = (RawImageInfo)imageInfo.getAuxiliaryInfo();
            DCRaw dcRaw = rawInfo.getDCRaw();
            captureDate = dcRaw.getCaptureDateTime();
        }
        if (captureDate != null) {
            long time = captureDate.getTime();
            return imageInfo.getFile().getName() + time + version;
        }
        return null;
    }

    static FileCache getCacheFor(ImageInfo imageInfo) {
        return FileCacheFactory.getGlobalCache();
    }

    static File getCachedImageFileFor(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        String cacheKey = RawImageCache.getCacheKeyFor(imageInfo);
        return cacheKey != null ? RawImageCache.getCachedImageFileFor(cacheKey) : null;
    }

    static File getCachedImageFileFor(String cacheKey) {
        FileCache fileCache = FileCacheFactory.getGlobalCache();
        return fileCache != null ? fileCache.getFileFor(cacheKey) : null;
    }

    static PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread) throws BadImageFileException, IOException, UnknownImageTypeException, UserCanceledException {
        File imageFile = RawImageCache.getCachedImageFileFor(imageInfo);
        if (imageFile != null) {
            String fileName = imageFile.getAbsolutePath();
            try {
                return new LCTIFFReader.TIFFImage(fileName);
            }
            catch (LCImageLibException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            RawImageCache rawImageCache = this;
            synchronized (rawImageCache) {
                try {
                    while (this.currentJob == null) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("Caching image: " + this.currentJob.cacheKey);
            long t1 = System.currentTimeMillis();
            FileCache fileCache = FileCacheFactory.getGlobalCache();
            if (fileCache != null) {
                try {
                    File cacheFile = fileCache.putToFile(this.currentJob.cacheKey);
                    try {
                        LCTIFFWriter writer = new LCTIFFWriter(cacheFile.getAbsolutePath(), this.currentJob.image.getWidth(), this.currentJob.image.getHeight());
                        writer.setByteField(34675, JAIContext.linearProfile.getData());
                        writer.putImageTiled(this.currentJob.image, null);
                    }
                    catch (LCImageLibException e) {
                        e.printStackTrace();
                    }
                    finally {
                        fileCache.notifyAboutCloseOf(cacheFile);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.currentJob = null;
            long t2 = System.currentTimeMillis();
            System.out.println("Image cached in " + (t2 - t1) + "ms");
        }
    }

    static {
        INSTANCE.start();
    }

    private static final class ImageToCache {
        final String cacheKey;
        final RenderedImage image;

        ImageToCache(String cacheKey, RenderedImage image) {
            this.cacheKey = cacheKey;
            this.image = image;
        }
    }
}

