/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.PhaseOneTIFFRawImageType;
import com.lightcrafts.image.types.TrueImageTypeProvider;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.IOException;
import java.nio.BufferUnderflowException;

final class PhaseOneTIFFRawImageProbe
implements TrueImageTypeProvider {
    static final PhaseOneTIFFRawImageProbe INSTANCE = new PhaseOneTIFFRawImageProbe();

    @Override
    public ImageType getTrueImageTypeOf(ImageInfo imageInfo) throws IOException {
        LCByteBuffer buf = imageInfo.getByteBuffer();
        try {
            buf.position(12);
            boolean isRaw = buf.getEquals("Raw", "ASCII");
            if (!isRaw) {
                buf.position(13);
                isRaw = buf.getEquals("waR", "ASCII");
            }
            if (isRaw) {
                ImageMetadata metadata = imageInfo.getCurrentMetadata();
                MetadataUtil.removePreviewMetadataFrom(metadata);
                MetadataUtil.removeWidthHeightFrom(metadata);
                return PhaseOneTIFFRawImageType.INSTANCE;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private PhaseOneTIFFRawImageProbe() {
    }
}

