/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFMetadataReader;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.metadata.TagHandler;
import com.lightcrafts.image.metadata.makernotes.NikonDirectory;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class NEFImageType
extends RawImageType
implements TagHandler {
    public static final NEFImageType INSTANCE = new NEFImageType();
    private static final String[] EXTENSIONS = new String[]{"nef", "nrw"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "NEF";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        RenderedImage image = TIFFImageType.getJPEGInterchangeImage(imageInfo, maxWidth, maxHeight);
        return image != null && image.getWidth() > 300 && image.getHeight() > 300 ? image : super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetadataDirectory dir = metadata.getDirectoryFor(NikonDirectory.class);
        if (dir != null) {
            return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(4354), 0, dir.getValue(4353), 0, 0);
        }
        return super.getThumbnailImage(imageInfo);
    }

    @Override
    public boolean handleTag(int tagID, int fieldType, int numValues, int byteCount, int valueOffset, int valueOffsetAdjustment, int subdirOffset, ImageInfo imageInfo, LCByteBuffer buf, ImageMetadataDirectory dir) throws IOException {
        switch (tagID) {
            case 17: {
                EXIFMetadataReader reader = new EXIFMetadataReader(imageInfo, buf, true);
                ImageMetadata tempMetadata = new ImageMetadata();
                ImageMetadataDirectory tempDir = tempMetadata.getDirectoryFor(EXIFDirectory.class, true);
                reader.readDirectory(subdirOffset, 0, tempDir);
                LongMetaValue offsetValue = (LongMetaValue)tempDir.getValue(513);
                LongMetaValue lengthValue = (LongMetaValue)tempDir.getValue(514);
                if (offsetValue == null || lengthValue == null) {
                    return true;
                }
                int offset = offsetValue.getIntValue();
                int length = lengthValue.getIntValue();
                if (offset <= 0 || length <= 0) {
                    return true;
                }
                ImageMetadataDirectory nikonDir = imageInfo.getCurrentMetadata().getDirectoryFor(NikonDirectory.class, true);
                offsetValue.setLongValueAt(offset + valueOffsetAdjustment, 0);
                nikonDir.putValue(4354, offsetValue);
                nikonDir.putValue(4353, lengthValue);
                return true;
            }
        }
        return false;
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        reader.setTagHandler(this);
        MetadataUtil.removePreviewMetadataFrom(reader.readMetadata());
    }

    private NEFImageType() {
    }
}

