/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.DoubleMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ImageMetaValue
implements Cloneable,
Comparable,
Externalizable {
    private boolean m_isDisplayable = true;
    private boolean m_isEditable = false;
    private boolean m_isEdited;
    private ImageMetadataDirectory m_owningDirectory;
    private int m_owningTagID;
    private String m_toStringCache;
    private String[] m_valuesCache;

    public final synchronized void appendValue(String newValue) {
        if (!this.m_isEditable) {
            throw new IllegalStateException();
        }
        this.appendValueImpl(newValue);
        this.m_isEdited = true;
        this.clearCache();
    }

    public void clearEdited() {
        this.m_isEdited = false;
    }

    public ImageMetaValue clone() {
        try {
            return (ImageMetaValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof ImageMetaValue) {
            ImageMetaValue rightValue = (ImageMetaValue)o;
            String leftString = this.getStringValue();
            String rightString = rightValue.getStringValue();
            if (leftString == null) {
                return rightString == null ? 0 : -1;
            }
            if (rightString == null) {
                return 1;
            }
            return leftString.compareTo(rightString);
        }
        throw new IllegalArgumentException("Can not compare an ImageMetaValue to a " + o.getClass().getName());
    }

    public int compareTo(String s) {
        String leftString = this.getStringValue();
        if (leftString == null) {
            return s == null ? 0 : -1;
        }
        return leftString.compareTo(s);
    }

    public static ImageMetaValue create(ImageMetaType type) {
        switch (type) {
            case META_DATE: {
                return new DateMetaValue();
            }
            case META_DOUBLE: {
                return new DoubleMetaValue();
            }
            case META_FLOAT: {
                return new FloatMetaValue();
            }
            case META_SBYTE: {
                return new ByteMetaValue();
            }
            case META_SLONG: {
                return new LongMetaValue();
            }
            case META_SRATIONAL: {
                return new RationalMetaValue();
            }
            case META_SSHORT: {
                return new ShortMetaValue();
            }
            case META_STRING: {
                return new StringMetaValue();
            }
            case META_UNDEFINED: {
                return new UndefinedMetaValue();
            }
            case META_UBYTE: {
                return new UnsignedByteMetaValue();
            }
            case META_ULONG: {
                return new UnsignedLongMetaValue();
            }
            case META_URATIONAL: {
                return new UnsignedRationalMetaValue();
            }
            case META_USHORT: {
                return new UnsignedShortMetaValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public final int getByteValue() {
        return (byte)this.getLongValue();
    }

    public double getDoubleValue() {
        return this.getLongValue();
    }

    public float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    public final int getIntValue() {
        return (int)this.getLongValue();
    }

    public abstract long getLongValue();

    public final ImageMetadataDirectory getOwningDirectory() {
        return this.m_owningDirectory;
    }

    public final int getOwningTagID() {
        return this.m_owningTagID;
    }

    public final short getShortValue() {
        return (short)this.getLongValue();
    }

    public final String getStringValue() {
        String[] values = this.getValues();
        return values != null ? values[0] : null;
    }

    public final String getTagName() {
        ImageMetadataDirectory dir = this.getOwningDirectory();
        return dir != null ? dir.getTagNameFor(this.getOwningTagID(), false) : null;
    }

    public abstract ImageMetaType getType();

    public final short getUnsignedByteValue() {
        return (short)(this.getLongValue() & 0xFFL);
    }

    public final int getUnsignedShortValue() {
        return (int)(this.getLongValue() & 0xFFFFL);
    }

    public abstract int getValueCount();

    public final synchronized String[] getValues() {
        if (this.m_valuesCache == null) {
            this.m_valuesCache = this.getValuesImpl();
        }
        return this.m_valuesCache;
    }

    public final boolean isDisplayable() {
        return this.m_isDisplayable;
    }

    public final boolean isEditable() {
        return this.m_isEditable;
    }

    public final boolean isEdited() {
        return this.m_isEdited;
    }

    public boolean isLegalValue(String value) {
        if (this.m_owningDirectory != null) {
            return this.m_owningDirectory.isLegalValue(this.m_owningTagID, value);
        }
        return true;
    }

    public boolean isNumeric() {
        return false;
    }

    public final void setByteValue(byte newValue) {
        this.setLongValue(newValue);
    }

    public void setDoubleValue(double newValue) {
        this.setLongValue((long)newValue);
    }

    public final void setFloatValue(float newValue) {
        this.setDoubleValue(newValue);
    }

    public final void setIntValue(int newValue) {
        this.setLongValue(newValue);
    }

    public final boolean setIsChangeable(boolean isChangeable) {
        boolean old = this.m_isEditable;
        this.m_isEditable = isChangeable;
        return old;
    }

    public abstract void setLongValue(long var1);

    public final void setNonDisplayable() {
        this.m_isDisplayable = false;
    }

    public final void setOwningDirectory(ImageMetadataDirectory dir) {
        this.m_owningDirectory = dir;
    }

    public final void setOwningTagID(int tagID) {
        this.m_owningTagID = tagID;
    }

    public void setShortValue(short newValue) {
        this.setLongValue(newValue);
    }

    public final synchronized void setValues(String ... newValues) {
        this.checkIsEditable();
        for (String value : newValues) {
            if (this.isLegalValue(value)) continue;
            throw new IllegalArgumentException(value);
        }
        this.setValuesImpl(newValues);
        this.dirty();
    }

    public final synchronized String toString() {
        ImageMetadataDirectory dir;
        if (this.m_toStringCache == null && (dir = this.getOwningDirectory()) != null) {
            this.m_toStringCache = dir.valueToString(this);
            if (this.m_toStringCache == null) {
                this.m_toStringCache = this.toStringImpl();
            }
        }
        return this.m_toStringCache;
    }

    public final String toStringWithoutDirectoryConsult() {
        return this.toStringImpl();
    }

    public Element toXMP(Document xmpDoc, String nsURI, String prefix) {
        String tagName = this.getTagName();
        if (tagName == null) {
            return null;
        }
        Element tagElement = null;
        String[] values = this.getValues();
        if (values.length == 1) {
            tagElement = xmpDoc.createElementNS(nsURI, prefix + ':' + tagName);
            XMLUtil.setTextContentOf(tagElement, values[0]);
        } else if (values.length > 1) {
            tagElement = xmpDoc.createElementNS(nsURI, prefix + ':' + tagName);
            Element seqElement = XMLUtil.addElementChildTo(tagElement, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Seq");
            for (String value : values) {
                Element listItem = XMLUtil.addElementChildTo(seqElement, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:li");
                XMLUtil.setTextContentOf(listItem, value);
            }
        }
        return tagElement;
    }

    @Override
    public abstract void readExternal(ObjectInput var1) throws IOException;

    @Override
    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    protected ImageMetaValue() {
    }

    protected abstract void appendValueImpl(String var1);

    protected final void checkIsEditable() {
        if (!this.m_isEditable) {
            throw new IllegalStateException();
        }
    }

    protected final synchronized void clearCache() {
        this.m_toStringCache = null;
        this.m_valuesCache = null;
    }

    protected void dirty() {
        this.m_isEdited = true;
        this.clearCache();
    }

    protected abstract String[] getValuesImpl();

    protected abstract void setValuesImpl(String[] var1);

    protected abstract String toStringImpl();

    protected final int readHeader(ObjectInput in) throws IOException {
        this.m_isEditable = in.readBoolean();
        this.m_isDisplayable = in.readBoolean();
        return in.readInt();
    }

    protected final void writeHeader(ObjectOutput out) throws IOException {
        out.writeBoolean(this.m_isEditable);
        out.writeBoolean(this.m_isDisplayable);
        out.writeInt(this.getValueCount());
    }
}

