/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.NumericMetaValue;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.Rational;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class FloatMetaValue
extends NumericMetaValue {
    private float[] m_value;

    public FloatMetaValue() {
    }

    public FloatMetaValue(float ... values) {
        this.m_value = values;
    }

    public FloatMetaValue(String ... values) {
        this.setValuesImpl(values);
    }

    @Override
    public FloatMetaValue clone() {
        FloatMetaValue copy = (FloatMetaValue)super.clone();
        copy.m_value = (float[])this.m_value.clone();
        return copy;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof NumericMetaValue) {
            NumericMetaValue rightVal = (NumericMetaValue)o;
            float leftFloat = this.getFloatValue();
            float rightFloat = rightVal.getFloatValue();
            return Float.compare(leftFloat, rightFloat);
        }
        return super.compareTo(o);
    }

    @Override
    public int compareTo(String s) {
        try {
            float rightFloat = s.indexOf(47) > 0 ? Rational.parseRational(s).floatValue() : Float.parseFloat(s);
            float leftFloat = this.getFloatValue();
            return Float.compare(leftFloat, rightFloat);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public double getDoubleValue() {
        return this.getFloatValue();
    }

    @Override
    public float getFloatValue() {
        return this.m_value[0];
    }

    public float[] getFloatValues() {
        return this.m_value;
    }

    @Override
    public long getLongValue() {
        return (long)this.getFloatValue();
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_FLOAT;
    }

    @Override
    public int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public boolean isLegalValue(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setDoubleValue(double newValue) {
        this.setFloatValue((float)newValue);
    }

    public synchronized void setFloatValueAt(float newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new float[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (float[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = newValue;
        this.dirty();
    }

    @Override
    public void setLongValue(long newValue) {
        this.setFloatValue(newValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new float[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readFloat();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (float value : this.m_value) {
            out.writeFloat(value);
        }
    }

    @Override
    protected void appendValueImpl(String newValue) {
        float newFloat = Float.parseFloat(newValue);
        if (this.m_value == null) {
            this.m_value = new float[]{newFloat};
        } else {
            this.m_value = (float[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newFloat;
        }
    }

    @Override
    protected String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        for (int i = 0; i < this.m_value.length; ++i) {
            value[i] = Float.toString(this.m_value[i]);
        }
        return value;
    }

    @Override
    protected void setValuesImpl(String[] newValue) {
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new float[newValue.length];
        }
        for (int i = 0; i < newValue.length; ++i) {
            this.m_value[i] = Float.parseFloat(newValue[i]);
        }
    }

    @Override
    protected String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (float value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

