/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.utils.bytebuffer.ArrayByteBuffer;
import java.io.IOException;

public final class MRWMetadataReader
extends ImageMetadataReader {
    private ArrayByteBuffer m_tiffBlock;
    private TIFFMetadataReader m_tiffMetadataReader;

    public MRWMetadataReader(ImageInfo imageInfo) {
        super(imageInfo, imageInfo.getByteBuffer());
    }

    public ArrayByteBuffer getTIFFBlock() {
        return this.m_tiffBlock;
    }

    @Override
    protected void readHeader() throws BadImageFileException, IOException {
        this.m_buf.position(0);
        if (this.m_buf.get() != 0) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        if (!this.m_buf.getEquals("MRM", "ASCII")) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        int blockSize = this.m_buf.getInt();
        while (true) {
            if (this.m_buf.get() != 0) {
                throw new BadImageFileException(this.m_imageInfo.getFile());
            }
            String blockName = this.m_buf.getString(3, "ASCII");
            blockSize = this.m_buf.getInt();
            if (blockName.equals("PRD")) {
                this.m_buf.skipBytes(blockSize);
                continue;
            }
            if (blockName.equals("TTW")) break;
            this.m_buf.skipBytes(blockSize);
        }
        this.m_tiffBlock = new ArrayByteBuffer(this.m_buf.getBytes(blockSize));
        this.m_tiffMetadataReader = new TIFFMetadataReader(this.m_imageInfo, this.m_tiffBlock);
        this.m_tiffMetadataReader.readHeader();
    }

    @Override
    protected void readAllDirectories() throws IOException {
        this.m_tiffMetadataReader.readAllDirectories();
    }
}

