/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.BadImageMetadataException;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.TagHandler;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ImageMetadataReader {
    public static final Level LOG_LEVEL = Level.WARNING;
    public static final Logger m_logger = Logger.getLogger("com.lightcrafts.image.metadata");
    protected final LCByteBuffer m_buf;
    protected final ImageInfo m_imageInfo;
    protected final ImageMetadata m_metadata;
    protected TagHandler m_tagHandler;

    public final ImageMetadata readMetadata() throws BadImageFileException, IOException {
        try {
            this.readHeader();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadImageFileException(this.m_imageInfo.getFile(), (Throwable)e);
        }
        try {
            this.readAllDirectories();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.logBadImageMetadata(e);
        }
        return this.m_metadata;
    }

    public static void logException(Exception e) {
        m_logger.log(LOG_LEVEL, "", e);
    }

    public final void setTagHandler(TagHandler handler) {
        this.m_tagHandler = handler;
    }

    protected ImageMetadataReader(ImageInfo imageInfo, LCByteBuffer metadataBuf) {
        this.m_imageInfo = imageInfo;
        this.m_buf = metadataBuf;
        this.m_metadata = imageInfo.getCurrentMetadata();
    }

    protected void logBadImageMetadata() {
        ImageMetadataReader.logException(new BadImageMetadataException(this.m_imageInfo.getFile()));
    }

    protected void logBadImageMetadata(String message) {
        ImageMetadataReader.logException(new BadImageMetadataException(this.m_imageInfo.getFile(), message));
    }

    protected void logBadImageMetadata(Throwable cause) {
    }

    protected abstract void readHeader() throws BadImageFileException, IOException;

    protected abstract void readAllDirectories() throws IOException;
}

