/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.AdobeResourceParserEventHandler;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGAPPDParser;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;

public final class IPTCMetadataReader
extends ImageMetadataReader
implements AdobeResourceParserEventHandler {
    private final ImageType m_fromType;
    private int m_iptcStartPos;
    private int m_iptcLength;

    public IPTCMetadataReader(ImageInfo imageInfo, LCByteBuffer segBuf, ImageType fromType) {
        super(imageInfo, segBuf);
        this.m_fromType = fromType;
        if (!(fromType instanceof JPEGImageType)) {
            this.m_iptcStartPos = this.m_buf.position();
            this.m_iptcLength = this.m_buf.remaining();
        }
    }

    @Override
    public boolean gotResource(int blockID, String name, int dataLength, File file, LCByteBuffer buf) {
        if (blockID == 1028) {
            this.m_iptcStartPos = this.m_buf.position();
            this.m_iptcLength = dataLength;
            return false;
        }
        return true;
    }

    @Override
    protected void readAllDirectories() throws IOException {
        if (this.m_iptcLength == 0) {
            return;
        }
        ImageMetadataDirectory dir = this.m_metadata.getDirectoryFor(IPTCDirectory.class, true);
        this.readDirectory(this.m_iptcStartPos, dir);
    }

    @Override
    protected void readHeader() throws BadImageFileException, IOException {
        if (this.m_fromType instanceof JPEGImageType) {
            JPEGAPPDParser.parse(this, this.m_imageInfo.getFile(), this.m_buf);
        }
    }

    private void readDirectory(int offset, ImageMetadataDirectory dir) throws IOException {
        this.m_buf.position(offset);
        while (offset < this.m_buf.limit() && this.readDirectoryEntry(offset, dir)) {
            offset = this.m_buf.position();
        }
    }

    private boolean readDirectoryEntry(int offset, ImageMetadataDirectory dir) throws IOException {
        this.m_buf.position(offset);
        if (this.m_buf.remaining() < 5) {
            return false;
        }
        if (this.m_buf.get() != 28) {
            return false;
        }
        int tagID = this.m_buf.getUnsignedShort();
        int byteCount = this.m_buf.getUnsignedShort();
        if ((byteCount & 0x8000) != 0) {
            int byteCountLength = byteCount & Short.MAX_VALUE;
            byteCount = 0;
            while (byteCountLength-- > 0) {
                byteCount = byteCount << 8 | this.m_buf.getUnsignedByte();
            }
        }
        if (byteCount > this.m_buf.remaining()) {
            this.logBadImageMetadata();
            return false;
        }
        ImageMetaValue value = this.readValue(dir, tagID, byteCount);
        if (value != null) {
            try {
                dir.putValue(tagID, value);
            }
            catch (IllegalArgumentException e) {
                this.logBadImageMetadata();
            }
        }
        return true;
    }

    private ImageMetaValue readValue(ImageMetadataDirectory dir, int tagID, int byteCount) throws IOException {
        switch (tagID) {
            case 512: {
                short value = (short)(this.m_buf.get() << 8 | this.m_buf.get());
                return new UnsignedShortMetaValue(value);
            }
            case 522: {
                return new UnsignedByteMetaValue(this.m_buf.get());
            }
            case 326: 
            case 542: 
            case 549: 
            case 567: 
            case 574: {
                if (byteCount < 8) break;
                String s = this.m_buf.getString(byteCount, "UTF-8");
                return new DateMetaValue(s);
            }
            default: {
                String s;
                int nullByte;
                if (byteCount < 1) break;
                String c = "ISO-8859-1";
                ImageMetaValue oldCharset = dir.getValue(346);
                if (oldCharset != null) {
                    byte[] utf8 = new byte[]{27, 37, 71};
                    if (oldCharset.getStringValue().getBytes() == utf8) {
                        c = "UTF-8";
                    }
                }
                if ((nullByte = (s = this.m_buf.getString(byteCount, c)).indexOf(0)) >= 0 && (s = s.substring(0, nullByte)).length() == 0) break;
                ImageMetaValue oldValue = dir.getValue(tagID);
                if (oldValue == null) {
                    return new StringMetaValue(s);
                }
                boolean old = oldValue.setIsChangeable(true);
                oldValue.appendValue(s);
                oldValue.setIsChangeable(old);
                return oldValue;
            }
        }
        return null;
    }
}

