/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.metadata.EXIFConstants;
import com.lightcrafts.image.metadata.EXIFParserEventHandler;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.DoubleMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.HashSet;

public final class EXIFParser {
    private final LCByteBuffer m_buf;
    private final EXIFParserEventHandler m_handler;
    private final File m_imageFile;
    private final boolean m_isSubdirectory;
    private boolean m_stop;

    public EXIFParser(EXIFParserEventHandler handler, File imageFile, LCByteBuffer exifSegBuf, boolean isSubdirectory) {
        this.m_buf = exifSegBuf;
        this.m_handler = handler;
        this.m_imageFile = imageFile;
        this.m_isSubdirectory = isSubdirectory;
    }

    public void parseAllDirectories() throws IOException {
        int ifdOffset = 6 + this.m_buf.getInt();
        HashSet<Integer> ifdOffsetSet = new HashSet<Integer>();
        while (ifdOffset != 0) {
            if (ifdOffset < 0) {
                this.m_handler.gotBadMetadata("IFD offset < 0");
                break;
            }
            if (!ifdOffsetSet.add(ifdOffset)) break;
            ImageMetadataDirectory dir = this.m_handler.gotDirectory();
            this.parseDirectory(ifdOffset, 0, dir);
            if (this.m_stop) break;
            ifdOffset = this.m_buf.getInt();
            if (ifdOffset <= 0 || (ifdOffset += 6) < this.m_buf.limit()) continue;
            this.m_handler.gotBadMetadata("IFD offset >= EXIF limit");
        }
    }

    public void parseDirectory(int offset, int valueOffsetAdjustment, ImageMetadataDirectory dir) throws IOException {
        int entryCount = this.m_buf.getUnsignedShort(offset);
        if (entryCount > 256) {
            entryCount = 256;
        }
        for (int entry = 0; entry < entryCount; ++entry) {
            try {
                int pos = EXIFParser.calcIFDEntryPosition(offset, entry);
                this.parseDirectoryEntry(pos, valueOffsetAdjustment, dir);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.m_handler.gotBadMetadata(e);
            }
            if (!this.m_stop) continue;
            return;
        }
        this.m_buf.position(EXIFParser.calcIFDEntryPosition(offset, entryCount));
    }

    public void parseHeader() throws BadImageFileException, IOException {
        this.m_buf.position(0);
        if (this.m_buf.remaining() < 14) {
            throw new BadImageFileException(this.m_imageFile);
        }
        if (!this.m_buf.getEquals("Exif", "ASCII")) {
            throw new BadImageFileException(this.m_imageFile);
        }
        this.m_buf.skipBytes(2);
        short byteOrder = this.m_buf.getShort();
        if (byteOrder == 18761) {
            this.m_buf.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder == 19789) {
            this.m_buf.order(ByteOrder.BIG_ENDIAN);
        } else {
            throw new BadImageFileException(this.m_imageFile);
        }
        if (this.m_buf.getUnsignedShort() != 42) {
            throw new BadImageFileException(this.m_imageFile);
        }
    }

    public ImageMetaValue parseValue(int tagID, int fieldType, int offset, int numValues) throws IOException {
        switch (fieldType) {
            case 2: {
                String s = this.parseString(offset, numValues);
                if (s == null) {
                    return null;
                }
                switch (tagID) {
                    case 306: 
                    case 36867: 
                    case 36868: {
                        return new DateMetaValue(s);
                    }
                }
                return new StringMetaValue(s);
            }
            case 6: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.get(offset + i);
                }
                return new ByteMetaValue(values);
            }
            case 1: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getUnsignedByte(offset + i);
                }
                return new UnsignedByteMetaValue(values);
            }
            case 9: {
                long[] values = new long[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[9];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getInt(offset + i * valueSize);
                }
                return new LongMetaValue(values);
            }
            case 4: {
                long[] values = new long[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[4];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getInt(offset + i * valueSize);
                }
                return new UnsignedLongMetaValue(values);
            }
            case 10: {
                Rational[] values = new Rational[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[10];
                int longSize = EXIFConstants.EXIF_FIELD_SIZE[9];
                for (int i = 0; i < numValues; ++i) {
                    try {
                        int pos = offset + i * valueSize;
                        values[i] = new Rational(this.m_buf.getInt(pos), this.m_buf.getInt(pos + longSize));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.m_handler.gotBadMetadata(e);
                        return null;
                    }
                }
                return new RationalMetaValue(values);
            }
            case 5: {
                Rational[] values = new Rational[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[5];
                int longSize = EXIFConstants.EXIF_FIELD_SIZE[4];
                for (int i = 0; i < numValues; ++i) {
                    try {
                        int pos = offset + i * valueSize;
                        values[i] = new Rational(this.m_buf.getInt(pos), this.m_buf.getInt(pos + longSize));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.m_handler.gotBadMetadata(e);
                        return null;
                    }
                }
                return new UnsignedRationalMetaValue(values);
            }
            case 8: {
                long[] values = new long[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[8];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getShort(offset + i * valueSize);
                }
                return new ShortMetaValue(values);
            }
            case 3: {
                long[] values = new long[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[3];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getUnsignedShort(offset + i * valueSize);
                }
                return new UnsignedShortMetaValue(values);
            }
            case 11: {
                float[] values = new float[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[11];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getFloat(offset + i * valueSize);
                }
                return new FloatMetaValue(values);
            }
            case 12: {
                double[] values = new double[numValues];
                int valueSize = EXIFConstants.EXIF_FIELD_SIZE[12];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getDouble(offset + i * valueSize);
                }
                return new DoubleMetaValue(values);
            }
            case 7: {
                return new UndefinedMetaValue(this.m_buf.getBytes(offset, numValues));
            }
        }
        throw new IllegalStateException(String.format("unknown field type (0x%0) for tag ID 0x%0", fieldType, tagID));
    }

    public void stopParsing() {
        this.m_stop = true;
    }

    private static int calcIFDEntryPosition(int ifdOffset, int entry) {
        return ifdOffset + 2 + entry * 12;
    }

    private int calcValueOffset(int byteCount, int valueOffsetAdjustment) throws IOException {
        if (byteCount <= 4) {
            return this.m_buf.position();
        }
        int offset = this.m_buf.getInt() + (this.m_isSubdirectory ? 0 : 6) + valueOffsetAdjustment;
        if (offset + byteCount > this.m_buf.limit()) {
            return -1;
        }
        return offset;
    }

    private void parseDirectoryEntry(int offset, int valueOffsetAdjustment, ImageMetadataDirectory dir) throws IOException {
        this.m_buf.position(offset);
        int tagID = this.m_buf.getUnsignedShort();
        if (tagID < 0) {
            return;
        }
        int fieldType = this.m_buf.getUnsignedShort();
        if (fieldType <= 0 || fieldType >= EXIFConstants.EXIF_FIELD_SIZE.length) {
            this.m_handler.gotBadMetadata(String.format("unknown field type (0x%0) for tag ID 0x%0", fieldType, tagID));
            return;
        }
        int numValues = this.m_buf.getInt();
        if (numValues < 0) {
            this.m_handler.gotBadMetadata(String.format("numValues (0x%x) < 0 for tag ID 0x%x", numValues, tagID));
            return;
        }
        int byteCount = numValues * EXIFConstants.EXIF_FIELD_SIZE[fieldType];
        if (byteCount <= 0) {
            return;
        }
        int valueOffset = this.calcValueOffset(byteCount, valueOffsetAdjustment);
        if (valueOffset < 0) {
            this.m_handler.gotBadMetadata(String.format("valueOffset < 0 for tag ID 0x%x", tagID));
            return;
        }
        int subdirOffset = (this.m_isSubdirectory ? 0 : 6) + this.m_buf.getInt(valueOffset) + valueOffsetAdjustment;
        this.m_handler.gotTag(tagID, fieldType, numValues, byteCount, valueOffset, valueOffsetAdjustment, subdirOffset, this.m_imageFile, this.m_buf, dir);
    }

    private String parseString(int offset, int maxLength) throws IOException {
        int length;
        for (length = 0; length < maxLength && this.m_buf.get(offset + length) != 0; ++length) {
        }
        return this.m_buf.getString(offset, length, "UTF-8");
    }

    private String parseUserComment(int offset, int count, int fieldType) throws IOException {
        byte[] bytes = this.m_buf.getBytes(offset, count *= EXIFConstants.EXIF_FIELD_SIZE[fieldType]);
        while (count > 0 && bytes[count - 1] == 32) {
            --count;
        }
        if (count > 8) {
            count -= 8;
            String charsetCode = new String(bytes, 0, 8).toUpperCase();
            if ("ASCII\u0000\u0000\u0000".equals(charsetCode)) {
                return new String(bytes, 8, count);
            }
            if ("UNICODE\u0000".equals(charsetCode)) {
                try {
                    return new String(bytes, 8, count, this.m_buf.order() == ByteOrder.LITTLE_ENDIAN ? "UTF-16LE" : "UTF-16BE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

