/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.ImageExportOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.IOException;

public abstract class IntegerExportOption
extends ImageExportOption {
    private int m_value;

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof IntegerExportOption)) {
            return false;
        }
        IntegerExportOption i = (IntegerExportOption)o;
        return i.getName().equals(this.getName()) && i.getValue() == this.getValue();
    }

    public int getValue() {
        return this.m_value;
    }

    public abstract boolean isLegalValue(int var1);

    public final void setValue(int newValue) {
        this.m_value = newValue;
    }

    @Override
    public final void setValue(String newValue) {
        this.setValue(Integer.parseInt(newValue));
    }

    @Override
    public void save(XmlNode node) {
        node = node.addChild(this.getName());
        String value = Integer.toString(this.getValue());
        node.setAttribute("value", value);
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        node = node.getChild(this.getName());
        this.m_value = Integer.parseInt(node.getAttribute("value"));
    }

    @Override
    public void readFrom(ImageExportOptionReader r) throws IOException {
        r.read(this);
    }

    @Override
    public void writeTo(ImageExportOptionWriter w) throws IOException {
        w.write(this);
    }

    protected IntegerExportOption(String name, int defaultValue, ImageExportOptions options) {
        super(name, options);
        this.setValue(defaultValue);
    }
}

