/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.editor.Document;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.RepaintManager;
import javax.swing.UIManager;

class DebugMenu
extends UpdatableDisposableMenu {
    WeakReference<Document> docRef = new WeakReference<Object>(null);
    List<JMenuItem> fixedItems = DebugMenu.createStaticItems();

    DebugMenu(ComboFrame frame) {
        super(frame, "Debug");
        for (JMenuItem item : this.fixedItems) {
            this.add(item);
        }
    }

    @Override
    void update() {
        Document oldDoc;
        Document newDoc;
        ComboFrame frame = this.getComboFrame();
        if (frame != null && (newDoc = frame.getDocument()) != (oldDoc = (Document)this.docRef.get())) {
            this.removeAll();
            if (newDoc != null) {
                Engine engine = newDoc.getEngine();
                List items = engine.getDebugItems();
                for (Object item : items) {
                    this.add((JMenuItem)item);
                }
            }
            for (JMenuItem item : this.fixedItems) {
                this.add(item);
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
    }

    private static LinkedList<JMenuItem> createStaticItems() {
        UIManager.LookAndFeelInfo[] lafs;
        LinkedList<JMenuItem> items = new LinkedList<JMenuItem>();
        boolean isDoubleBuffered = RepaintManager.currentManager(null).isDoubleBufferingEnabled();
        JMenuItem menuItem = new JCheckBoxMenuItem("Double Buffering", isDoubleBuffered);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractButton button = (AbstractButton)event.getSource();
                boolean selected = button.isSelected();
                RepaintManager rm = RepaintManager.currentManager(null);
                rm.setDoubleBufferingEnabled(selected);
            }
        });
        items.add(menuItem);
        JMenu lafMenu = new JMenu("Set Look And Feel");
        for (final UIManager.LookAndFeelInfo info : lafs = UIManager.getInstalledLookAndFeels()) {
            menuItem = new JMenuItem(info.getName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String className = info.getClassName();
                    Application.setLookAndFeel(className);
                }
            });
            lafMenu.add(menuItem);
        }
        items.add(lafMenu);
        menuItem = new JMenuItem("Show TCTool");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Class.forName("tilecachetool.TCTool").newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        items.add(menuItem);
        menuItem = new JMenuItem("Show Component Tree");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Class<?> clazz = Class.forName("com.lightcrafts.app.test.ComponentTree");
                    Method method = clazz.getDeclaredMethod("show", Component.class);
                    List<ComboFrame> frames = Application.getCurrentFrames();
                    for (ComboFrame frame : frames) {
                        method.invoke(null, frame);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        items.add(menuItem);
        menuItem = new JMenuItem("Run GC");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Runtime.getRuntime().gc();
            }
        });
        items.add(menuItem);
        return items;
    }
}

