/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.AbstractLayout;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.LayoutHeader;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.browser.ctrls.BrowserControls;
import com.lightcrafts.ui.browser.ctrls.FolderCtrl;
import com.lightcrafts.ui.browser.view.ImageBrowserFooter;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.editor.DocUndoHistory;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.layout.FadingTabConfiguration;
import com.lightcrafts.ui.layout.SmartSplitPane;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.templates.TemplateControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ComboLayout
extends AbstractLayout {
    private static final int MiddleDividerLoc = -1;
    private static final String MiddleDividerKey = "middleDividerLocation";
    private SmartSplitPane middleSplit;
    private JPanel browserPanel;
    private JComponent editorToolBar;
    private BrowserControls browserToolBar;
    private ImageBrowserFooter footer;
    private final ComboFrame frame;

    ComboLayout(TemplateControl templates, Editor editor, DocUndoHistory history, FolderCtrl folders, ImageBrowserScrollPane browser, MetadataScroll info, LayoutHeader header, ComboFrame frame) {
        super(AbstractLayout.LayoutType.Combo, templates, editor, history, folders, browser, info, header);
        this.frame = frame;
        this.browserToolBar = new BrowserControls(browser, frame);
        this.editorToolBar = editor.getToolBar();
        this.initFaders();
        this.browserPanel = new JPanel(new BorderLayout());
        this.browserPanel.add(browser);
        this.browserPanel.add((Component)this.browserToolBar, "North");
        this.footer = new ImageBrowserFooter();
        browser.getBrowser().addBrowserListener(this.footer);
        this.browserPanel.add((Component)this.footer, "South");
        this.middleSplit = new SmartSplitPane(MiddleDividerKey, null);
        this.middleSplit.setLeftComponent(editor.getImage());
        this.middleSplit.setRightComponent(this.browserPanel);
        this.middleSplit.setResizeWeight(0.5);
        this.middleSplit.restoreFromPrefs(-1, 0);
        this.leftSplit.setLeftComponent(this.leftFader);
        this.leftSplit.setRightComponent(this.middleSplit);
        this.leftSplit.setResizeWeight(0.0);
        this.rightSplit.setLeftComponent(this.leftSplit);
        this.rightSplit.setRightComponent(this.rightFader);
        this.rightSplit.setResizeWeight(1.0);
        this.restoreLayout();
        this.setLayout(new BorderLayout());
        this.add(this.rightSplit);
        this.add((Component)this.editorToolBar, "North");
        this.add((Component)this.leftFader.getButtonContainer(), "West");
        this.add((Component)this.rightFader.getButtonContainer(), "East");
    }

    @Override
    void updateEditor(TemplateControl templates, Editor editor, DocUndoHistory history, MetadataScroll info) {
        super.updateEditor(templates, editor, history, info);
        this.remove(this.editorToolBar);
        this.editorToolBar = editor.getToolBar();
        this.add((Component)this.editorToolBar, "North");
        JComponent image = editor.getImage();
        this.middleSplit.setLeftFrozenDivider(image);
        this.remove(this.leftFader.getButtonContainer());
        this.remove(this.rightFader.getButtonContainer());
        this.initFaders();
        this.leftSplit.setLeftFrozenDivider(this.leftFader);
        this.rightSplit.setRightFrozenDivider(this.rightFader);
        this.add((Component)this.leftFader.getButtonContainer(), "West");
        this.add((Component)this.rightFader.getButtonContainer(), "East");
        this.validate();
    }

    @Override
    void updateBrowser() {
        this.browserPanel.remove(this.browserToolBar);
        this.browserToolBar.dispose();
        this.browserToolBar = new BrowserControls(this.browser, this.frame);
        this.browserPanel.add((Component)this.browserToolBar, "North");
        this.footer = new ImageBrowserFooter();
        this.browser.getBrowser().addBrowserListener(this.footer);
        this.browserPanel.add((Component)this.footer, "South");
        this.validate();
    }

    @Override
    List<FadingTabConfiguration> getLeftFaderConfs() {
        String templatesLabel = Locale.LOCALE.get("TemplatesTabLabel");
        String templatesTip = Locale.LOCALE.get("TemplatesTabToolTip");
        String foldersLabel = Locale.LOCALE.get("FoldersTabLabel");
        String foldersTip = Locale.LOCALE.get("FoldersTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.folders, foldersLabel, foldersTip));
        tabs.add(new FadingTabConfiguration(this.templates, templatesLabel, templatesTip));
        return tabs;
    }

    @Override
    List<FadingTabConfiguration> getRightFaderConfs() {
        String infoLabel = Locale.LOCALE.get("InfoTabLabel");
        String infoTip = Locale.LOCALE.get("InfoTabToolTip");
        String toolsLabel = Locale.LOCALE.get("ToolsTabLabel");
        String toolsTip = Locale.LOCALE.get("ToolsTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.editor.getToolStack(), toolsLabel, toolsTip));
        tabs.add(new FadingTabConfiguration(this.info, infoLabel, infoTip));
        return tabs;
    }

    @Override
    String getDefaultLeftFaderTab() {
        return Locale.LOCALE.get("FoldersTabLabel");
    }

    @Override
    String getDefaultRightFaderTab() {
        return Locale.LOCALE.get("ToolsTabLabel");
    }

    @Override
    void dispose() {
        super.dispose();
        this.browserToolBar.dispose();
    }
}

