/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.button;

import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.utils.SubstanceConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseButtonShaper
implements SubstanceButtonShaper {
    public static GeneralPath getBaseOutline(AbstractButton button, float radius, Set<SubstanceConstants.Side> straightSides) {
        int width = button.getWidth();
        int height = button.getHeight();
        return BaseButtonShaper.getBaseOutline(width, height, radius, straightSides);
    }

    public static GeneralPath getBaseOutline(int width, int height, float radius, Set<SubstanceConstants.Side> straightSides) {
        return BaseButtonShaper.getBaseOutline(width, height, radius, straightSides, null);
    }

    public static GeneralPath getBaseOutline(int width, int height, float radius, Set<SubstanceConstants.Side> straightSides, Insets insets) {
        int ys;
        boolean isTopLeftCorner = straightSides != null && (straightSides.contains((Object)SubstanceConstants.Side.LEFT) || straightSides.contains((Object)SubstanceConstants.Side.TOP));
        boolean isTopRightCorner = straightSides != null && (straightSides.contains((Object)SubstanceConstants.Side.RIGHT) || straightSides.contains((Object)SubstanceConstants.Side.TOP));
        boolean isBottomRightCorner = straightSides != null && (straightSides.contains((Object)SubstanceConstants.Side.RIGHT) || straightSides.contains((Object)SubstanceConstants.Side.BOTTOM));
        boolean isBottomLeftCorner = straightSides != null && (straightSides.contains((Object)SubstanceConstants.Side.LEFT) || straightSides.contains((Object)SubstanceConstants.Side.BOTTOM));
        int xs = insets == null ? 0 : insets.left;
        int n = ys = insets == null ? 0 : insets.top;
        if (insets != null) {
            width -= insets.right + insets.left;
        }
        if (insets != null) {
            height -= insets.top + insets.bottom;
        }
        GeneralPath result = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height, 0.5)));
        if (Math.max(width, height) < 15) {
            radius3 /= 2.0f;
        }
        if (isTopLeftCorner) {
            result.moveTo(xs, ys);
        } else {
            result.moveTo((float)xs + radius, ys);
        }
        if (isTopRightCorner) {
            result.lineTo(xs + width - 1, ys);
        } else {
            if (isTopLeftCorner || (float)(xs + width) - radius - 1.0f >= radius) {
                result.lineTo((float)(xs + width) - radius - 1.0f, ys);
            }
            result.quadTo((float)(xs + width - 1) - radius3, (float)ys + radius3, xs + width - 1, (float)ys + radius);
        }
        if (isBottomRightCorner) {
            result.lineTo(xs + width - 1, ys + height - 1);
        } else {
            if (isTopRightCorner || (float)(ys + height) - radius - 1.0f >= radius) {
                result.lineTo(xs + width - 1, (float)(ys + height) - radius - 1.0f);
            }
            result.quadTo((float)(xs + width - 1) - radius3, (float)(ys + height - 1) - radius3, (float)(xs + width) - radius - 1.0f, ys + height - 1);
        }
        if (isBottomLeftCorner) {
            result.lineTo(xs, ys + height - 1);
        } else {
            if (isBottomRightCorner || (float)(xs + width) - radius - 1.0f >= radius) {
                result.lineTo((float)xs + radius, ys + height - 1);
            }
            result.quadTo((float)xs + radius3, (float)(ys + height - 1) - radius3, xs, (float)(ys + height) - radius - 1.0f);
        }
        if (isTopLeftCorner) {
            result.lineTo(xs, ys);
        } else {
            if (isBottomLeftCorner || (float)(ys + height) - radius - 1.0f >= radius) {
                result.lineTo(xs, (float)ys + radius);
            }
            result.quadTo((float)xs + radius3, (float)ys + radius3, (float)xs + radius, ys);
        }
        return result;
    }

    public static GeneralPath getTriangleButtonOutline(int width, int height, float radius) {
        GeneralPath result = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height, 0.5)));
        if (Math.max(width, height) < 15) {
            radius3 /= 2.0f;
        }
        result.moveTo(radius, 0.0f);
        if ((float)width - radius - 1.0f >= radius) {
            result.lineTo((float)width - radius - 1.0f, 0.0f);
        }
        result.quadTo((float)(width - 1) - radius3, radius3, width - 1, radius);
        float h2 = ((float)height - 1.0f) / 2.0f;
        if (h2 >= radius) {
            result.lineTo(width - 1, h2);
        }
        result.lineTo(((float)width - 1.0f) / 2.0f, height - 1);
        result.lineTo(0.0f, h2);
        if (h2 >= radius) {
            result.lineTo(0.0f, h2);
        }
        if ((float)height - radius - 1.0f >= radius) {
            result.lineTo(0.0f, radius);
        }
        result.quadTo(radius3, radius3, radius, 0.0f);
        return result;
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton button, Insets insets) {
        return this.getButtonOutline(button, insets, button.getWidth(), button.getHeight());
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton button) {
        return this.getButtonOutline(button, null);
    }
}

