/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.media.jai.util.PropertyGeneratorImpl;
import com.lightcrafts.mediax.jai.OpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.ROI;
import com.lightcrafts.mediax.jai.ROIShape;
import com.lightcrafts.mediax.jai.RenderableOp;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.WarpOpImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;

class FilteredSubsamplePropertyGenerator
extends PropertyGeneratorImpl {
    public FilteredSubsamplePropertyGenerator() {
        super(new String[]{"FilteredSubsample"}, new Class[]{Boolean.TYPE}, new Class[]{RenderedOp.class, RenderableOp.class});
    }

    @Override
    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                return null;
            }
            ROI srcROI = (ROI)property;
            Rectangle srcBounds = null;
            PlanarImage dst = op.getRendering();
            if (dst instanceof WarpOpImage && !((OpImage)dst).hasExtender(0)) {
                WarpOpImage warpIm = (WarpOpImage)dst;
                srcBounds = new Rectangle(src.getMinX() + warpIm.getLeftPadding(), src.getMinY() + warpIm.getTopPadding(), src.getWidth() - warpIm.getWidth() + 1, src.getHeight() - warpIm.getHeight() + 1);
            } else {
                srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            }
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect(new ROIShape(srcBounds));
            }
            float sx = 1.0f / (float)pb.getIntParameter(1);
            float sy = 1.0f / (float)pb.getIntParameter(2);
            AffineTransform transform = new AffineTransform((double)sx, 0.0, 0.0, (double)sy, 0.0, 0.0);
            ROI dstROI = srcROI.transform(transform);
            Rectangle dstBounds = op.getBounds();
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect(new ROIShape(dstBounds));
            }
            return dstROI;
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        String[] properties = new String[]{"roi"};
        return properties;
    }
}

