/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.opimage;

import com.lightcrafts.mediax.jai.NullOpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.Map;

public class PointMapperOpImage
extends NullOpImage {
    private AffineTransform transform;
    private AffineTransform inverseTransform;

    public PointMapperOpImage(PlanarImage source, Map configuration, AffineTransform transform) throws NoninvertibleTransformException {
        super((RenderedImage)source, null, configuration, 1);
        if (transform == null) {
            throw new IllegalArgumentException("transform == null!");
        }
        this.transform = transform;
        this.inverseTransform = transform.createInverse();
    }

    @Override
    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException("sourceIndex != 0!");
        }
        return this.inverseTransform.transform(destPt, null);
    }

    @Override
    public Point2D mapSourcePoint(Point2D sourcePt, int sourceIndex) {
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException("sourceIndex != 0!");
        }
        return this.inverseTransform.transform(sourcePt, null);
    }

    @Override
    public synchronized void dispose() {
        this.getSourceImage(0).dispose();
        super.dispose();
    }
}

