/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.media.jai.mlib.MlibAffineBicubicOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineBilinearOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineNearestOpImage;
import com.lightcrafts.media.jai.mlib.MlibAffineTableOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.EnumeratedParameter;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.InterpolationBicubic;
import com.lightcrafts.mediax.jai.InterpolationBicubic2;
import com.lightcrafts.mediax.jai.InterpolationBilinear;
import com.lightcrafts.mediax.jai.InterpolationNearest;
import com.lightcrafts.mediax.jai.InterpolationTable;
import com.lightcrafts.mediax.jai.operator.ShearDescriptor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;

public class MlibShearRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(hints);
        Interpolation interp = (Interpolation)args.getObjectParameter(4);
        RenderedImage source = args.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(args, layout) || !MediaLibAccessor.hasSameNumBands(args, layout) || source.getTileWidth() >= 32768 || source.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender extender = RIFUtil.getBorderExtenderHint(hints);
        float shear_amt = args.getFloatParameter(0);
        EnumeratedParameter shear_dir = (EnumeratedParameter)args.getObjectParameter(1);
        float xTrans = args.getFloatParameter(2);
        float yTrans = args.getFloatParameter(3);
        double[] backgroundValues = (double[])args.getObjectParameter(5);
        AffineTransform tr = new AffineTransform();
        if (shear_dir.equals(ShearDescriptor.SHEAR_HORIZONTAL)) {
            tr.setTransform(1.0, 0.0, shear_amt, 1.0, xTrans, 0.0);
        } else {
            tr.setTransform(1.0, shear_amt, 0.0, 1.0, 0.0, yTrans);
        }
        if (interp instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(source, extender, (Map)hints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(source, extender, (Map)hints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(source, extender, (Map)hints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(source, extender, (Map)hints, layout, tr, interp, backgroundValues);
        }
        return null;
    }
}

