/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.JaiI18N;
import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.media.jai.mlib.MlibUtils;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

final class MlibDivideIntoConstOpImage
extends PointOpImage {
    private double[] constants;

    public MlibDivideIntoConstOpImage(RenderedImage source, Map config, ImageLayout layout, double[] constants) {
        super(source, layout, config, true);
        this.constants = MlibUtils.initConstants(constants, this.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        int formatTag = MediaLibAccessor.findCompatibleTag(sources, dest);
        MediaLibAccessor srcAccessor = new MediaLibAccessor(source, srcRect, formatTag);
        MediaLibAccessor dstAccessor = new MediaLibAccessor(dest, destRect, formatTag);
        mediaLibImage[] srcML = srcAccessor.getMediaLibImages();
        mediaLibImage[] dstML = dstAccessor.getMediaLibImages();
        switch (dstAccessor.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < dstML.length; ++i) {
                    double[] mlconstants = dstAccessor.getDoubleParameters(i, this.constants);
                    Image.ConstDiv((mediaLibImage)dstML[i], (mediaLibImage)srcML[i], (double[])mlconstants);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < dstML.length; ++i) {
                    double[] mlconstants = dstAccessor.getDoubleParameters(i, this.constants);
                    Image.ConstDiv_Fp((mediaLibImage)dstML[i], (mediaLibImage)srcML[i], (double[])mlconstants);
                }
                break;
            }
            default: {
                String className = this.getClass().getName();
                throw new RuntimeException(className + JaiI18N.getString("Generic2"));
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }
}

