/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.Glass3DTitlePainter;
import org.jvnet.substance.title.SubstanceHeaderPainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ArcHeaderPainter
implements SubstanceHeaderPainter {
    private SubstanceTitlePainter secondaryPainter;
    private boolean isPaintingToolbars;
    private boolean isPaintingToolbarDropShadows;

    public ArcHeaderPainter() {
        this(true);
    }

    public ArcHeaderPainter(boolean isPaintingToolbars) {
        this.isPaintingToolbars = isPaintingToolbars;
        this.secondaryPainter = new Glass3DTitlePainter();
    }

    public String getDisplayName() {
        return "Arc";
    }

    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, boolean hasDarkBorder) {
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        rgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme scheme = theme.getColorScheme();
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.lineTo(width, height / 2);
        clipTop.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        GradientPaint gradientTopLeft = new GradientPaint(0.0f, 0.0f, scheme.getLightColor(), width / 2, 0.0f, scheme.getUltraLightColor());
        rgraphics.setPaint(gradientTopLeft);
        rgraphics.fillRect(0, 0, width / 2, height);
        GradientPaint gradientTopRight = new GradientPaint(width / 2, 0.0f, scheme.getUltraLightColor(), width, 0.0f, scheme.getLightColor());
        rgraphics.setPaint(gradientTopRight);
        rgraphics.fillRect(width / 2, 0, width - width / 2, height);
        GradientPaint gradientBottomLeft = new GradientPaint(0.0f, height / 2, scheme.getMidColor(), width / 2, height / 2, scheme.getLightColor());
        GradientPaint gradientBottomRight = new GradientPaint(width / 2, height / 2, scheme.getLightColor(), width, height / 2, scheme.getMidColor());
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, height / 2);
        clipBottom.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        rgraphics.setPaint(gradientBottomLeft);
        rgraphics.fillRect(0, 0, width / 2, height);
        rgraphics.setPaint(gradientBottomRight);
        rgraphics.fillRect(width / 2, 0, width - width / 2, height);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, height / 2);
        mid.quadTo(width / 2, height / 4, 0.0f, height / 2);
        rgraphics.setPaint(gradientBottomLeft);
        rgraphics.setClip(new Rectangle(0, 0, width / 2, height));
        rgraphics.draw(mid);
        rgraphics.setPaint(gradientBottomRight);
        rgraphics.setClip(new Rectangle(width / 2, 0, width - width / 2, height));
        rgraphics.draw(mid);
        graphics.drawImage((Image)rectangular, 0, 0, null);
    }

    public void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceTheme theme, boolean hasDarkBorder) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
        JComponent titlePane = ui.getTitlePane();
        int dx = comp.getX();
        if (titlePane != null) {
            dx += parent.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
        }
        int pWidth = titlePane == null ? parent.getWidth() : titlePane.getWidth();
        int pHeight = parent.getHeight();
        ColorScheme scheme = theme.getColorScheme();
        GradientPaint gradientBottomLeft = new GradientPaint(-dx, pHeight / 2, scheme.getMidColor(), -dx + pWidth / 2, pHeight / 2, scheme.getLightColor());
        GradientPaint gradientBottomRight = new GradientPaint(-dx + pWidth / 2, pHeight / 2, scheme.getLightColor(), -dx + pWidth, pHeight / 2, scheme.getMidColor());
        graphics.setPaint(gradientBottomLeft);
        graphics.fillRect(-dx, 0, pWidth / 2, pHeight);
        graphics.setPaint(gradientBottomRight);
        graphics.fillRect(-dx + pWidth / 2, 0, pWidth - pWidth / 2, pHeight);
    }

    public SubstanceTitlePainter getSecondaryPainter() {
        return this.secondaryPainter;
    }

    public boolean isPaintingToolbars() {
        return this.isPaintingToolbars;
    }

    public boolean isPaintingToolbarDropShadows() {
        return this.isPaintingToolbarDropShadows;
    }

    public void setPaintingToolbarDropShadows(boolean isPaintingToolbarDropShadows) {
        this.isPaintingToolbarDropShadows = isPaintingToolbarDropShadows;
    }

    public void setPaintingToolbars(boolean isPaintingToolbars) {
        this.isPaintingToolbars = isPaintingToolbars;
    }
}

