/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.linux;

import com.lightcrafts.platform.linux.Locale;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.utils.WebBrowser;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class TestSSE2 {
    static String osname = System.getProperty("os.name");

    TestSSE2() {
    }

    static boolean hasSSE2() {
        String regex = osname.indexOf("Linux") >= 0 ? "^flags\t\t:.*sse2" : (osname.indexOf("SunOS") >= 0 ? "^\t.*sse2" : (osname.indexOf("FreeBSD") >= 0 ? "^hw.instruction_sse: 1" : "^  Features=.*SSE2"));
        return TestSSE2.getCpuInfoLine(regex) != null;
    }

    private static String getCpuInfoLine(String regex) {
        String line = null;
        String[] cmd = osname.indexOf("Linux") >= 0 ? new String[]{"cat", "/proc/cpuinfo"} : (osname.indexOf("SunOS") >= 0 ? new String[]{"sh", "-c", "isainfo -nv ; psrinfo -pv"} : (osname.indexOf("FreeBSD") >= 0 ? new String[]{"sysctl", "hw"} : new String[]{"dmesg"}));
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            InputStream in = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null && !Pattern.compile(regex).matcher(line).find()) {
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    static void showDialog() {
        String regex = osname.indexOf("Linux") >= 0 ? TestSSE2.getCpuInfoLine("^model name\t: ") : (osname.indexOf("SunOS") >= 0 ? TestSSE2.getCpuInfoLine("^\t") : (osname.indexOf("FreeBSD") >= 0 ? TestSSE2.getCpuInfoLine("^hw.model: ") : TestSSE2.getCpuInfoLine("^CPU: ")));
        String model = TestSSE2.getCpuInfoLine(regex);
        if (model != null) {
            model = model.replaceFirst(Matcher.quoteReplacement(regex), "");
        }
        String messageA = Locale.LOCALE.get("CantRunSSE2Title");
        String messageB = Locale.LOCALE.get("CantRunSSE2");
        String messageC = Locale.LOCALE.get("FoundProcCpuinfo", new String[]{model});
        String messageD = Locale.LOCALE.get("LearnMoreSSE2");
        String messageE = Locale.LOCALE.get("LearnMoreSSE2URL");
        JLabel title = new JLabel(messageA);
        title.setFont(title.getFont().deriveFont(22.0f));
        title.setAlignmentX(0.5f);
        StringBuffer buffer = new StringBuffer();
        buffer.append(messageB);
        buffer.append("\n\n");
        buffer.append(messageC);
        buffer.append("\n\n");
        buffer.append(messageD);
        final String url = messageE;
        JLabel link = new JLabel(url);
        link.setForeground(Color.blue);
        link.setAlignmentX(0.5f);
        link.setCursor(new Cursor(12));
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                WebBrowser.browse((String)url);
            }
        });
        JTextArea text = TextAreaFactory.createTextArea((String)buffer.toString(), (int)40);
        text.setBackground(new JPanel().getBackground());
        Box box = Box.createVerticalBox();
        box.add(title);
        box.add(Box.createVerticalStrut(8));
        box.add(text);
        box.add(Box.createVerticalStrut(8));
        box.add(link);
        JOptionPane.showMessageDialog(null, box, messageA, 0);
    }
}

