/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public final class Statistics
extends JPanel {
    private long[] stats = null;
    private int percent = 0;
    private static final Color DARK_BLUE = new Color(10, 10, 120);
    private static final Color DARK_RED = new Color(240, 40, 40);
    private static final Color BACKGROUND = new Color(180, 180, 220);
    private static final Font DEFAULT_FONT = new Font("monospaced", 1, 14);
    private static final String[] LABELS = new String[]{"     Tile Count: ", "     Cache Hits: ", "   Cache Misses: ", "       Add Tile: ", "    Remove Tile: ", "  Remove(flush): ", "Remove(control): ", "     Remove(gc): ", "Update(addTile): ", "Update(getTile): ", " Used Memory(%): "};

    public Statistics() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(270, 200));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        LineBorder lineBorder = new LineBorder(Color.gray, 1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(lineBorder, "Statistics", 1, 2, DEFAULT_FONT, Color.black);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, titledBorder);
        this.setBorder(compoundBorder);
        this.stats = new long[LABELS.length];
    }

    public void set(long tileCount, long cacheHits, long cacheMisses, long addTile, long removeTile, long removeFlushed, long removeMemoryControl, long removeGC, long updateAddTile, long updateGetTile, int percent) {
        this.stats[0] = tileCount;
        this.stats[1] = cacheHits;
        this.stats[2] = cacheMisses;
        this.stats[3] = addTile;
        this.stats[4] = removeTile;
        this.stats[5] = removeFlushed;
        this.stats[6] = removeMemoryControl;
        this.stats[7] = removeGC;
        this.stats[8] = updateAddTile;
        this.stats[9] = updateGetTile;
        this.stats[10] = percent;
        this.percent = percent;
        this.repaint();
    }

    public void set(int percent) {
        this.percent = percent;
        this.stats[10] = percent;
        this.repaint();
    }

    public synchronized void clear() {
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i] = 0L;
        }
        this.percent = 0;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        Insets insets = this.getInsets();
        g2d.setColor(BACKGROUND);
        g2d.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        int x1 = insets.left + 10;
        int y1 = insets.top + 10;
        int x2 = x1 + 20;
        int y2 = this.getHeight() - insets.bottom - 5;
        int w = 20;
        int h = y2 - y1 + 1;
        g2d.setColor(DARK_BLUE);
        g2d.fillRect(x1, y1, w, h);
        g2d.setColor(Color.white);
        g2d.drawRect(x1 - 1, y1 - 1, w + 1, h + 1);
        g2d.setColor(DARK_RED);
        int p = (int)((float)h * ((float)this.percent / 100.0f));
        if (p > 0) {
            g2d.fillRect(x1, y2 - p, w, p);
        }
        int x = insets.left + 50;
        int y = insets.top + 20;
        g2d.setColor(Color.black);
        g2d.setFont(DEFAULT_FONT);
        int fontHeight = this.getFontMetrics(DEFAULT_FONT).getAscent();
        for (int i = 0; i < LABELS.length; ++i) {
            g2d.drawString(LABELS[i] + this.stats[i], x, y);
            y += fontHeight;
        }
    }
}

