/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import tilecachetool.RingBuffer;

public final class MemoryChart
extends JComponent
implements Runnable,
ComponentListener {
    private Thread thread;
    private long delay = 500L;
    private double free_memory;
    private double total_memory;
    private RingBuffer rbuf = new RingBuffer(500);
    private Insets insets = null;
    private int data_length = -1;
    private int percent;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 0;
    private int w = 0;
    private int h = 0;
    private static final StringBuffer buf1 = new StringBuffer(32);
    private static final StringBuffer buf2 = new StringBuffer(32);
    private static final StringBuffer buf3 = new StringBuffer(32);
    private static final int BAR_WIDTH = 5;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Color BLUE = new Color(100, 150, 220);
    private static final Color DARK_BLUE = new Color(20, 20, 120);
    private static final Rectangle SBOX = new Rectangle(130, 20, 85, 45);
    private static final Font DEFAULT_FONT = new Font("monospaced", 1, 14);

    public MemoryChart() {
        this.setBackground(Color.gray);
        this.setPreferredSize(new Dimension(480, 140));
        EmptyBorder b2 = new EmptyBorder(10, 10, 10, 10);
        BevelBorder b1 = new BevelBorder(1);
        this.setBorder(new CompoundBorder(b1, b2));
        this.addComponentListener(this);
        this.insets = this.getInsets();
        buf1.append("Alloc Memory: ");
        buf2.append(" Used Memory: ");
        buf3.append("Percent Used: ");
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int width = this.getWidth() - 5;
        if (this.data_length != width) {
            this.data_length = width;
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.data_length = this.getWidth() - 5;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("MemoryChartThread");
        this.thread.setPriority(1);
        this.thread.start();
    }

    @Override
    public void run() {
        Thread current_thread = Thread.currentThread();
        while (this.thread == current_thread && !this.isShowing() || this.getSize().width < 5 || this.getSize().height < 5) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        while (this.thread == current_thread && this.isShowing()) {
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.thread = null;
    }

    public void setDelay(long interval) {
        this.delay = interval > 0L ? interval : 1L;
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.x1 = this.insets.left;
        this.y1 = this.insets.top;
        this.x2 = this.getWidth() - this.insets.right - 5 - 1;
        this.y2 = this.getHeight() - this.insets.bottom - 1;
        this.w = this.x2 - this.x1 + 1;
        this.h = this.y2 - this.y1 + 1;
        g2d.setBackground(Color.darkGray);
        g2d.clearRect(this.x1, this.y1, this.w, this.h);
        this.free_memory = RUNTIME.freeMemory();
        this.total_memory = RUNTIME.totalMemory();
        float v = 100.0f * (float)((this.total_memory - this.free_memory) / this.total_memory);
        this.rbuf.write(v);
        int bh = (int)((float)this.h * this.rbuf.read(this.rbuf.getCount() - 1) / 100.0f);
        this.drawBarGraph(g2d, this.x2, this.y2, bh);
        this.drawGrids(g2d, this.x1, this.y1, this.w, this.h);
        this.drawLegend(g2d);
        this.drawData(g2d);
    }

    private void drawGrids(Graphics2D g2d, int x1, int y1, int w, int h) {
        g2d.setColor(Color.cyan);
        g2d.drawRect(x1, y1, w + 5 - 1, h);
        float slope = (float)(this.y2 - y1) / 10.0f;
        g2d.setColor(BLUE);
        for (int i = 1; i < 10; ++i) {
            int y = (int)((float)i * slope) + y1;
            g2d.drawLine(x1, y, this.x2 - 1, y);
        }
    }

    private void drawBarGraph(Graphics2D g2d, int x2, int y2, int v) {
        g2d.setColor(BLUE);
        g2d.fillRect(x2, this.y1, 5, this.h);
        g2d.setColor(Color.yellow);
        g2d.fillRect(x2, y2 - v, 5, v + 1);
    }

    private void drawLegend(Graphics2D g2d) {
        this.percent = (int)(100.0f * (float)((this.total_memory - this.free_memory) / this.total_memory));
        g2d.setColor(DARK_BLUE);
        g2d.fillRect(this.x1 + 5, this.y1 + 5, 200, 50);
        g2d.setColor(Color.white);
        g2d.setFont(DEFAULT_FONT);
        buf1.delete(14, 31);
        buf1.append((long)this.total_memory);
        g2d.drawString(buf1.toString(), this.insets.left + 10, this.insets.top + 20);
        buf2.delete(14, 31);
        buf2.append((long)(this.total_memory - this.free_memory));
        g2d.drawString(buf2.toString(), this.insets.left + 10, this.insets.top + 35);
        buf3.delete(14, 31);
        buf3.append(this.percent + "%");
        g2d.drawString(buf3.toString(), this.insets.left + 10, this.insets.top + 50);
    }

    private void drawData(Graphics2D g2d) {
        g2d.setColor(Color.yellow);
        float slope_x = (float)(this.w - 5 + 3) / ((float)this.rbuf.getSize() - 1.0f);
        float slope_y = (float)this.h / 100.0f;
        for (int i = 1; i < this.rbuf.getCount(); ++i) {
            float p1 = this.rbuf.read(i - 1) / 100.0f;
            float p2 = this.rbuf.read(i) / 100.0f;
            int px1 = this.x1 + (int)((float)(i - 1) * slope_x);
            int py1 = this.y2 - (int)((float)this.h * p1);
            int px2 = this.x1 + (int)((float)i * slope_x);
            int py2 = this.y2 - (int)((float)this.h * p2);
            g2d.drawLine(px1, py1, px2, py2);
        }
    }
}

