/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.file;

import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.file.FileUtil;

public final class FileRenamer {
    private String m_extension;
    private int m_index = -1;
    private boolean m_indexAfter;
    private int m_indexDigits;
    private String m_indexSeparator;
    private String m_append;
    private String m_name;
    private String m_prepend;

    public String getNewNameFor(String oldName) {
        StringBuilder newName = new StringBuilder();
        if (this.m_name != null) {
            newName.append(this.m_name);
        } else {
            newName.append(FileUtil.trimExtensionOf(oldName));
        }
        if (this.m_prepend != null) {
            newName.insert(0, this.m_prepend);
        }
        if (this.m_append != null) {
            newName.append(this.m_append);
        }
        if (this.m_index >= 0) {
            String index = TextUtil.zeroPad(this.m_index++, 10, this.m_indexDigits);
            if (this.m_indexAfter) {
                if (this.m_indexSeparator != null) {
                    newName.append(this.m_indexSeparator);
                }
                newName.append(index);
            } else {
                if (this.m_indexSeparator != null) {
                    newName.insert(0, this.m_indexSeparator);
                }
                newName.insert(0, index);
            }
        }
        newName.append('.');
        newName.append(this.m_extension);
        return newName.toString();
    }

    public void setExtension(String extension) {
        this.m_extension = extension;
    }

    public void setIndexComponents(int start, boolean after, int digits, String separator) {
        if (start >= 0 && digits < 1) {
            throw new IllegalArgumentException();
        }
        this.m_index = start;
        this.m_indexAfter = after;
        this.m_indexDigits = digits;
        this.m_indexSeparator = separator;
    }

    public void setNameComponents(String prepend, String name, String append) {
        this.m_append = append;
        this.m_name = name;
        this.m_prepend = prepend;
    }

    public static void main(String[] args) {
        FileRenamer fr = new FileRenamer();
        fr.setExtension("jpg");
        fr.setNameComponents(null, "Vacation", null);
        fr.setIndexComponents(1, false, 2, "-");
        System.out.println(fr.getNewNameFor("CRW_1234.CRW"));
    }
}

