/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import com.lightcrafts.utils.CloseableManager;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.bytebuffer.FileByteBuffer;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class SoftChunkyFileByteBuffer
extends FileByteBuffer {
    private static final int CHUNK_SIZE = 8192;
    private final Reference<ByteBuffer>[] m_chunk;

    public SoftChunkyFileByteBuffer(File file, CloseableManager closeableManager) {
        super(file, closeableManager);
        this.m_chunk = new SoftReference[(int)(file.length() / 8192L + 1L)];
    }

    @Override
    public byte get(int pos) throws IOException {
        int offsetPos = this.initialOffset() + pos;
        if (offsetPos + 1 > this.limit()) {
            throw new BufferUnderflowException();
        }
        return this.getChunkForPos(offsetPos).get(offsetPos % 8192);
    }

    @Override
    public LCByteBuffer get(byte[] dest, int offset, int length) throws IOException {
        int pos = this.position();
        this.getContiguousBytes(this.initialOffset() + pos, dest, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public double getDouble(int pos) throws IOException {
        return Double.longBitsToDouble(this.get248Bytes(this.initialOffset() + pos, 8));
    }

    @Override
    public float getFloat(int pos) throws IOException {
        return Float.intBitsToFloat((int)this.get248Bytes(this.initialOffset() + pos, 4));
    }

    @Override
    public int getInt(int pos) throws IOException {
        return (int)this.get248Bytes(this.initialOffset() + pos, 4);
    }

    @Override
    public long getLong(int pos) throws IOException {
        return this.get248Bytes(this.initialOffset() + pos, 8);
    }

    @Override
    public short getShort(int pos) throws IOException {
        return (short)this.get248Bytes(this.initialOffset() + pos, 2);
    }

    private long get248Bytes(int pos, int length) throws IOException {
        int endPos = pos + length;
        if (endPos > this.limit()) {
            throw new BufferUnderflowException();
        }
        int lastPos = endPos - 1;
        ByteBuffer chunkI = this.getChunkForPos(pos);
        ByteBuffer chunkJ = this.getChunkForPos(lastPos);
        int modI = pos % 8192;
        if (chunkI == chunkJ) {
            return this.get248Bytes(chunkI, modI, length);
        }
        byte[] temp = new byte[length];
        int firstLength = 8192 - modI;
        int lastLength = lastPos % 8192 + 1;
        ByteBufferUtil.getBytes(chunkI, modI, temp, 0, firstLength);
        ByteBufferUtil.getBytes(chunkJ, 0, temp, length - lastLength, lastLength);
        return this.get248Bytes(ByteBuffer.wrap(temp), 0, length);
    }

    private long get248Bytes(ByteBuffer buf, int pos, int length) {
        buf.order(this.order());
        try {
            switch (length) {
                case 2: {
                    return buf.getShort(pos);
                }
                case 4: {
                    return buf.getInt(pos);
                }
                case 8: {
                    return buf.getLong(pos);
                }
            }
            throw new IllegalArgumentException("length (" + length + ") must be 2, 4, or 8");
        }
        catch (IndexOutOfBoundsException e) {
            BufferUnderflowException bue = new BufferUnderflowException();
            bue.initCause(e);
            throw bue;
        }
    }

    private synchronized ByteBuffer getChunk(int c) throws IOException {
        ByteBuffer buf;
        Reference<ByteBuffer> ref = this.m_chunk[c];
        if (ref != null && (buf = ref.get()) != null) {
            return buf;
        }
        buf = ByteBuffer.allocate(8192);
        int origPos = this.position();
        int chunkPos = c * 8192;
        this.position(chunkPos);
        int length = Math.min(8192, this.limit() - chunkPos);
        super.get(buf.array(), 0, length);
        this.position(origPos);
        this.m_chunk[c] = new SoftReference<ByteBuffer>(buf);
        return buf;
    }

    private ByteBuffer getChunkForPos(int pos) throws IOException {
        return this.getChunk(pos / 8192);
    }

    private byte[] getContiguousBytes(int pos, byte[] dest, int offset, int length) throws IOException {
        int endPos = pos + length;
        if (endPos > this.limit()) {
            throw new BufferUnderflowException();
        }
        int lastPos = endPos - 1;
        ByteBuffer chunkI = this.getChunkForPos(pos);
        ByteBuffer chunkJ = this.getChunkForPos(lastPos);
        int modI = pos % 8192;
        if (chunkI == chunkJ) {
            ByteBufferUtil.getBytes(chunkI, modI, dest, offset, length);
        } else {
            int firstLength = 8192 - modI;
            int lastLength = lastPos % 8192 + 1;
            ByteBufferUtil.getBytes(chunkI, modI, dest, offset, firstLength);
            ByteBufferUtil.getBytes(chunkJ, 0, dest, length - lastLength, lastLength);
            offset += firstLength;
            int j = lastPos / 8192;
            for (int i = pos / 8192 + 1; i < j; ++i) {
                ByteBuffer chunk = this.getChunk(i);
                ByteBufferUtil.getBytes(chunk, 0, dest, offset, 8192);
                offset += 8192;
            }
        }
        return dest;
    }
}

