/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ArrayByteBuffer
extends LCByteBuffer {
    private final ByteBuffer m_buf;

    public ArrayByteBuffer(byte[] array) {
        this(ByteBuffer.wrap(array));
    }

    public ArrayByteBuffer(ByteBuffer buf) {
        super(buf.capacity());
        this.m_buf = buf;
    }

    @Override
    public byte get(int pos) {
        return this.m_buf.get(this.initialOffset() + pos);
    }

    @Override
    public LCByteBuffer get(byte[] dest, int offset, int length) {
        int pos = this.position();
        this.m_buf.position(this.initialOffset() + pos);
        this.m_buf.get(dest, offset, length);
        this.position(pos + length);
        return this;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    @Override
    public double getDouble(int pos) {
        return this.m_buf.getDouble(this.initialOffset() + pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.m_buf.getFloat(this.initialOffset() + pos);
    }

    @Override
    public int getInt(int pos) {
        return this.m_buf.getInt(this.initialOffset() + pos);
    }

    @Override
    public long getLong(int pos) {
        return this.m_buf.getLong(this.initialOffset() + pos);
    }

    @Override
    public short getShort(int pos) {
        return this.m_buf.getShort(this.initialOffset() + pos);
    }

    @Override
    public ArrayByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        this.m_buf.limit(newLimit);
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.m_buf.order();
    }

    @Override
    public ArrayByteBuffer order(ByteOrder order) {
        this.m_buf.order(order);
        return this;
    }

    @Override
    public ArrayByteBuffer put(int pos, byte b) {
        this.m_buf.put(this.initialOffset() + pos, b);
        return this;
    }

    @Override
    public ArrayByteBuffer putDouble(int pos, double value) {
        this.m_buf.putDouble(this.initialOffset() + pos, value);
        return this;
    }

    @Override
    public ArrayByteBuffer putFloat(int pos, float value) {
        this.m_buf.putFloat(this.initialOffset() + pos, value);
        return this;
    }

    @Override
    public ArrayByteBuffer putInt(int pos, int value) {
        this.m_buf.putInt(this.initialOffset() + pos, value);
        return this;
    }

    @Override
    public ArrayByteBuffer putLong(int pos, long value) {
        this.m_buf.putLong(this.initialOffset() + pos, value);
        return this;
    }

    @Override
    public ArrayByteBuffer putShort(int pos, short value) {
        this.m_buf.putShort(this.initialOffset() + pos, value);
        return this;
    }
}

