/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.platform.Platform;

public class MemoryLimits {
    public static final double DefaultMemoryFraction = 0.3;
    private static final int physicalMax = Platform.getPlatform().getPhysicalMemoryInMB();

    public static int getMinimum() {
        return 512;
    }

    public static int getMaximum() {
        int maximum = physicalMax / 2;
        maximum = Math.max(maximum, MemoryLimits.getMinimum());
        if (System.getProperty("sun.arch.data.model").equals("32")) {
            maximum = Math.min(maximum, 2048);
        }
        return maximum;
    }

    public static int getDefault() {
        int limit = (int)Math.round(0.3 * (double)physicalMax);
        limit = Math.max(limit, MemoryLimits.getMinimum());
        limit = Math.min(limit, MemoryLimits.getMaximum());
        return limit;
    }
}

