/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.templates.TemplateTreeNode;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class TemplateCellRenderer
implements TreeCellRenderer {
    private static final Icon ExpandedIcon = IconFactory.createIcon(TemplateCellRenderer.class, "expanded.png");
    private static final Icon CollapsedIcon = IconFactory.createIcon(TemplateCellRenderer.class, "collapsed.png");
    private TreeCellRenderer backingRenderer;
    private static final Color NonSelectedForeground = LightZoneSkin.Colors.ToolPanesForeground;
    private static final Color SelectedForeground = Color.black;
    private static final Border PreviewedBorder = BorderFactory.createLineBorder(NonSelectedForeground);
    private static final Border NonPreviewedBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    TemplateCellRenderer() {
        JTree tree = new JTree();
        this.backingRenderer = tree.getCellRenderer();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)this.backingRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (leaf) {
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                Object last = path.getLastPathComponent();
                if (last instanceof TemplateTreeNode) {
                    TemplateTreeNode node = (TemplateTreeNode)last;
                    if (node.isPreviewed()) {
                        label.setBorder(PreviewedBorder);
                    } else {
                        label.setBorder(NonPreviewedBorder);
                    }
                } else {
                    label.setBorder(NonPreviewedBorder);
                }
            }
            label.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
            label.setOpaque(false);
            label.setIcon(null);
            label.setDisabledIcon(null);
        } else {
            label.setBorder(NonPreviewedBorder);
            label.setBackground(LightZoneSkin.Colors.FrameBackground);
            label.setOpaque(true);
            Icon icon = expanded ? ExpandedIcon : CollapsedIcon;
            label.setIcon(icon);
            label.setDisabledIcon(icon);
        }
        label.setForeground(selected ? SelectedForeground : NonSelectedForeground);
        Dimension size = label.getPreferredSize();
        label.setPreferredSize(new Dimension(200, size.height));
        return label;
    }
}

