/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.ui.region.Curve;
import com.lightcrafts.ui.region.CurveComponent;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import com.lightcrafts.ui.region.EditCurveMode;
import com.lightcrafts.ui.region.FollowMouseMode;
import com.lightcrafts.ui.region.MajorRegionMode;
import com.lightcrafts.ui.region.MoveCurveMode;
import com.lightcrafts.ui.region.RegionMode;
import com.lightcrafts.ui.region.RegionModel;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class NewCurveMode
extends MajorRegionMode {
    private static KeyStroke DeleteKey1 = KeyStroke.getKeyStroke(127, 0);
    private static KeyStroke DeleteKey2 = KeyStroke.getKeyStroke(8, 0);
    private long mouseEnteredTime;

    NewCurveMode(RegionModel model, CurveComponent comp) {
        super(model, comp);
    }

    NewCurveMode(RegionMode mode) {
        super(mode);
    }

    @Override
    void modeEntered() {
        this.comp.setCursor(NewPointCursor);
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CurveSelection selection = NewCurveMode.this.model.getSelection();
                CurveIterator curves = selection.iterator();
                while (curves.hasNext()) {
                    NewCurveMode.this.model.removeCurve(NewCurveMode.this.comp, curves.nextCurve());
                }
            }
        };
        this.comp.registerKeyboardAction(deleteAction, DeleteKey1, 2);
        this.comp.registerKeyboardAction(deleteAction, DeleteKey2, 2);
    }

    @Override
    void modeExited() {
        this.comp.unregisterKeyboardAction(DeleteKey1);
        this.comp.unregisterKeyboardAction(DeleteKey2);
    }

    @Override
    void save(XmlNode node) {
    }

    @Override
    void restore(XmlNode node) throws XMLException {
    }

    @Override
    Curve getEditingCurve() {
        return null;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (System.currentTimeMillis() - this.mouseEnteredTime < 100L) {
            return;
        }
        if (event.isPopupTrigger() || event.getButton() != 1) {
            return;
        }
        Point p = event.getPoint();
        Curve curve = this.comp.getCurveAround(p);
        CurveSelection selection = this.model.getSelection();
        CurveIterator curves = selection.iterator();
        if (curve == null && curves.hasNext()) {
            selection.clear();
            return;
        }
        if (curve != null && event.getClickCount() == 2 && event.getClickCount() == 2) {
            this.model.editStart();
            this.model.setMajorMode(new EditCurveMode(this, curve));
            this.model.editEnd();
            return;
        }
        if (curve != null) {
            if ((event.getModifiers() & 1) == 0 && !selection.isSelected(curve)) {
                selection.clear();
            }
            this.model.getSelection().addCurve(curve);
            this.model.setMinorMode(new MoveCurveMode(this, p));
        } else {
            this.model.editStart();
            if (this.comp.makesSpotCurves()) {
                this.comp.addSpotCurve(p);
                this.model.editEnd();
                return;
            }
            Curve newCurve = this.comp.showsClonePoints() ? this.comp.addCloneCurve(p) : this.comp.addCurve();
            this.comp.addPoint(newCurve, p);
            int index = this.comp.addPoint(newCurve, p);
            FollowMouseMode nextMode = new FollowMouseMode(this, newCurve, index);
            this.model.setMajorModeWithoutExitOrEnter(nextMode);
            this.modeExited();
            this.model.editEnd();
            ((MajorRegionMode)nextMode).modeEntered();
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.mouseEnteredTime = System.currentTimeMillis();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.mouseEnteredTime = 0L;
        this.updateCursor(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.updateCursor(event);
    }

    private void updateCursor(MouseEvent event) {
        Cursor newCursor;
        Point p = event.getPoint();
        Curve curve = this.comp.getCurveAround(p);
        Cursor cursor = newCursor = curve != null ? MoveCurveCursor : NewPointCursor;
        if (newCursor != this.cursor) {
            this.comp.setCursor(newCursor);
            this.cursor = newCursor;
        }
    }
}

