/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.region;

import com.lightcrafts.model.CloneContour;
import com.lightcrafts.ui.region.Curve;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

class CurveContour
implements CloneContour {
    private Shape outer;
    private float width;
    private Point2D clonePt;
    private Point2D translation;

    CurveContour(Curve curve) {
        this.outer = curve;
        this.width = curve.getWidth();
        this.clonePt = curve.getClonePoint();
        if (curve.isValidShape()) {
            this.outer = new GeneralPath(curve);
        }
    }

    @Override
    public Shape getOuterShape() {
        return this.outer;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public synchronized Point2D getTranslation() {
        return this.translation;
    }

    @Override
    public Point2D getClonePoint() {
        return this.clonePt;
    }

    synchronized void addTranslation(Point2D p) {
        if (this.translation == null) {
            this.translation = p;
        } else {
            double x = this.translation.getX();
            double y = this.translation.getY();
            this.translation = new Point2D.Double(x + p.getX(), y + p.getY());
        }
    }
}

