/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.print.PrintLayoutModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class DimensionTextField
extends JTextField
implements DocumentListener {
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            DimensionTextField text = (DimensionTextField)event.getSource();
            text.selectAll();
        }
    };
    private static final NumberFormat InchFormat = new DecimalFormat("0.00");
    private static final NumberFormat CmFormat = new DecimalFormat("0.0");
    private static final NumberFormat PointFormat = new DecimalFormat("0");
    private Listener listener;
    private NumberFormat format;

    DimensionTextField() {
        this.setInputVerifier(new NumberVerifier());
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.format = InchFormat;
        this.setFixedSize();
        this.setHorizontalAlignment(4);
        this.addFocusListener(FocusSelector);
        this.registerKeyboardActions();
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    void setUnit(PrintLayoutModel.LengthUnit unit) {
        if (unit == PrintLayoutModel.LengthUnit.CM) {
            this.format = CmFormat;
        } else if (unit == PrintLayoutModel.LengthUnit.INCH) {
            this.format = InchFormat;
        } else if (unit == PrintLayoutModel.LengthUnit.POINT) {
            this.format = PointFormat;
        } else {
            throw new IllegalArgumentException("Unrecognized LengthUnit");
        }
    }

    PrintLayoutModel.LengthUnit getUnit() {
        if (this.format == CmFormat) {
            return PrintLayoutModel.LengthUnit.CM;
        }
        if (this.format == InchFormat) {
            return PrintLayoutModel.LengthUnit.INCH;
        }
        if (this.format == PointFormat) {
            return PrintLayoutModel.LengthUnit.POINT;
        }
        throw new IllegalStateException("Unknown LengthUnit");
    }

    void setDimension(double dimension) {
        String text = this.format.format(dimension);
        this.setText(text);
    }

    double getDimension() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            throw new IllegalStateException("Unverified dimension text");
        }
        String text = this.getText();
        try {
            return this.format.parse(text).doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unparsable dimension text");
        }
    }

    private void setFixedSize() {
        this.setText("0.000");
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    private void registerKeyboardActions() {
        ActionListener upAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = DimensionTextField.this.getInputVerifier();
                if (!verifier.verify(DimensionTextField.this)) {
                    return;
                }
                PrintLayoutModel.LengthUnit unit = DimensionTextField.this.getUnit();
                double delta = unit == PrintLayoutModel.LengthUnit.POINT ? 1.0 : 0.1;
                double dim = DimensionTextField.this.getDimension();
                if ((dim += delta) >= 0.0) {
                    DimensionTextField.this.setDimension(dim);
                }
            }
        };
        ActionListener downAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = DimensionTextField.this.getInputVerifier();
                if (!verifier.verify(DimensionTextField.this)) {
                    return;
                }
                PrintLayoutModel.LengthUnit unit = DimensionTextField.this.getUnit();
                double delta = unit == PrintLayoutModel.LengthUnit.POINT ? 1.0 : 0.1;
                double dim = DimensionTextField.this.getDimension();
                if ((dim -= delta) >= 0.0) {
                    DimensionTextField.this.setDimension(dim);
                } else {
                    DimensionTextField.this.setDimension(0.0);
                }
            }
        };
        this.registerKeyboardAction(upAction, "Increment", KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(downAction, "Decrement", KeyStroke.getKeyStroke(40, 0), 0);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    private void handleDocumentChange() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
            if (this.listener != null) {
                double x = this.getDimension();
                this.listener.dimensionChanged(x);
            }
        }
    }

    private class NumberVerifier
    extends InputVerifier {
        private NumberVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            double x;
            String text = DimensionTextField.this.getText();
            try {
                x = DimensionTextField.this.format.parse(text).doubleValue();
            }
            catch (ParseException e) {
                return false;
            }
            return x >= 0.0;
        }
    }

    static interface Listener {
        public void dimensionChanged(double var1);
    }
}

