/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.whitepoint;

import com.lightcrafts.model.WhitePointOperation;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.mode.DropperMode;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.whitepoint.ColorText;
import com.lightcrafts.ui.operation.whitepoint.Locale;
import com.lightcrafts.ui.swing.ColorSwatch;
import com.lightcrafts.ui.toolkit.DropperButton;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;

public class WhitePointControl
extends OpControl {
    private DropperButton dropperButton = new DropperButton();
    private ColorSwatch swatch;
    private ColorText text;
    private DropperMode dropperMode;
    private boolean isDropperModeCancelling;
    private static final String ColorTag = "Color";

    public WhitePointControl(WhitePointOperation op, OpStack stack) {
        super(op, stack);
        this.dropperButton.setAlignmentX(1.0f);
        this.dropperButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean selected;
                boolean bl = selected = event.getStateChange() == 1;
                if (selected) {
                    WhitePointControl.this.getComboFrame().getEditor().setMode(EditorMode.ARROW);
                    WhitePointControl.this.notifyListenersEnterMode(WhitePointControl.this.dropperMode);
                } else if (!WhitePointControl.this.isDropperModeCancelling) {
                    WhitePointControl.this.notifyListenersExitMode(WhitePointControl.this.dropperMode);
                }
            }
        });
        this.dropperMode = new DropperMode(this);
        this.dropperMode.addListener(new DropperMode.Listener(){

            @Override
            public void pointSelected(Point2D p) {
                WhitePointControl.this.setWhitePoint(p);
            }

            @Override
            public void modeCancelled() {
                WhitePointControl.this.isDropperModeCancelling = true;
                WhitePointControl.this.dropperButton.setSelected(false);
                WhitePointControl.this.isDropperModeCancelling = false;
            }
        });
        Color color = op.getWhitePoint();
        this.swatch = new ColorSwatch(color);
        this.text = new ColorText(color);
        Box content = Box.createHorizontalBox();
        content.add(this.swatch);
        content.add(Box.createHorizontalStrut(8));
        content.add(this.text);
        content.add(Box.createHorizontalStrut(32));
        content.add(this.dropperButton);
        content.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setContent(content);
        this.readyForUndo();
    }

    private void setWhitePoint(Color color) {
        ((WhitePointOperation)this.getOperation()).setWhitePoint(color);
        this.updateWhitePoint();
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("SetWhitePointEditName"));
        }
    }

    private void setWhitePoint(Point2D p) {
        ((WhitePointOperation)this.getOperation()).setWhitePoint(p);
        this.updateWhitePoint();
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("DropperEditName"));
        }
    }

    private Color getWhitePoint() {
        return ((WhitePointOperation)this.getOperation()).getWhitePoint();
    }

    private void updateWhitePoint() {
        Color color = this.getWhitePoint();
        this.swatch.setColor(color);
        this.text.setColor(color);
    }

    @Override
    public void save(XmlNode node) {
        super.save(node);
        Color color = this.getWhitePoint();
        XmlNode whiteNode = node.addChild(ColorTag);
        whiteNode.setAttribute("r", Integer.toString(color.getRed()));
        whiteNode.setAttribute("g", Integer.toString(color.getGreen()));
        whiteNode.setAttribute("b", Integer.toString(color.getBlue()));
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        super.restore(node);
        XmlNode whiteNode = node.getChild(ColorTag);
        int r = Integer.parseInt(whiteNode.getAttribute("r"));
        int g = Integer.parseInt(whiteNode.getAttribute("g"));
        int b = Integer.parseInt(whiteNode.getAttribute("b"));
        Color color = new Color(r, g, b);
        this.undoSupport.restoreStart();
        this.setWhitePoint(color);
        if (this.dropperButton.isSelected()) {
            this.dropperButton.setSelected(false);
        }
        this.undoSupport.restoreEnd();
    }

    @Override
    protected String getHelpTopic() {
        return "Tool-White_Balance";
    }
}

