/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.generic;

import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.operation.generic.ConfiguredBoundedRangeModel;
import com.lightcrafts.ui.operation.generic.ConfiguredSlider;
import com.lightcrafts.ui.operation.generic.ConfiguredTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class GenericSlider
extends JPanel {
    private ConfiguredBoundedRangeModel model;
    private JLabel label;
    private ConfiguredSlider slider;
    private ConfiguredTextField text;

    GenericSlider(String key, SliderConfig config) {
        this.setLayout(new BoxLayout(this, 0));
        this.label = new JLabel(key + ":", 0);
        this.label.setHorizontalAlignment(4);
        this.label.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.slider = new ConfiguredSlider(config);
        this.slider.setPaintTicks(true);
        this.model = this.slider.getConfiguredModel();
        this.add(this.label);
        this.add(this.slider);
        if (config.hasText()) {
            DecimalFormat format = config.getDecimalFormat();
            this.text = new ConfiguredTextField(this.model, format);
            this.add(this.text);
            this.slider.setFocusable(false);
            this.slider.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GenericSlider.this.text.requestFocusInWindow();
                        }
                    });
                }
            });
            this.text.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    GenericSlider.this.slider.addMouseWheelListener(GenericSlider.this.text);
                }

                @Override
                public void focusLost(FocusEvent event) {
                    GenericSlider.this.slider.removeMouseWheelListener(GenericSlider.this.text);
                }
            });
        }
    }

    Component getLabel() {
        return this.label;
    }

    Component getSlider() {
        return this.slider;
    }

    Component getText() {
        return this.text;
    }

    void setConfiguredValue(double value) {
        this.model.setConfiguredValue(value);
    }

    double getConfiguredValue() {
        return this.model.getConfiguredValue();
    }

    void setSliderPosition(int value) {
        this.model.setValue(value);
    }

    int getSliderPosition() {
        return this.model.getValue();
    }

    void setBackgroundRecurse(Color color) {
        super.setBackground(color);
        this.label.setBackground(color);
        this.slider.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
    }

    void setFontRecurse(Font font) {
        super.setFont(font);
        this.label.setFont(font);
        this.slider.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
    }

    void addChangeListener(ChangeListener listener) {
        this.model.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.model.removeChangeListener(listener);
    }

    void addSliderMouseListener(MouseListener listener) {
        this.slider.addMouseListener(listener);
    }

    void removeSliderMouseListener(MouseListener listener) {
        this.slider.removeMouseListener(listener);
    }

    public static void main(String[] args) {
        SliderConfig config = new SliderConfig(0.0, 1.0, 0.5, 0.01, false, new DecimalFormat());
        final GenericSlider slider = new GenericSlider("name", config);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                double value = slider.getConfiguredValue();
                System.out.println(value);
            }
        });
        JFrame frame = new JFrame("Test");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(slider);
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 400, 50);
        frame.setVisible(true);
    }
}

