/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.CloneOperation;
import com.lightcrafts.model.ColorDropperOperation;
import com.lightcrafts.model.ColorPickerDropperOperation;
import com.lightcrafts.model.ColorPickerOperation;
import com.lightcrafts.model.Engine;
import com.lightcrafts.model.GenericOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.RawAdjustmentOperation;
import com.lightcrafts.model.SpotOperation;
import com.lightcrafts.model.WhitePointOperation;
import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpActions;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStackListener;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.operation.clone.CloneControl;
import com.lightcrafts.ui.operation.clone.SpotControl;
import com.lightcrafts.ui.operation.colorbalance.ColorPickerControl;
import com.lightcrafts.ui.operation.colorbalance.ColorPickerDropperControl;
import com.lightcrafts.ui.operation.drag.DraggableStack;
import com.lightcrafts.ui.operation.drag.DraggableStackListener;
import com.lightcrafts.ui.operation.generic.GenericControl;
import com.lightcrafts.ui.operation.whitebalance.ColorDropperControl;
import com.lightcrafts.ui.operation.whitebalance.RawAdjustmentControl;
import com.lightcrafts.ui.operation.whitepoint.WhitePointControl;
import com.lightcrafts.ui.operation.zone.ZoneControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class OpStack
extends DraggableStack
implements Scrollable,
UndoableEditListener {
    public static final int PreferredWidth = 280;
    private static final Preferences Prefs;
    private static final String AutoExpandKey = "AutoExpand";
    private Engine engine;
    private LinkedList<OpControl> opControls;
    private LinkedList<SelectableControl> extraControls;
    private SelectableControl selection;
    private OpActions actions;
    private Map<String, Integer> nameCounts = new HashMap<String, Integer>();
    private boolean isStackDragging;
    private boolean autoExpandControls;
    private LinkedList<OpStackListener> listeners;
    private OpStackUndoSupport undoSupport;
    private static final String ZoneTag = "ZoneOperation";
    private static final String CloneTag = "CloneOperation";
    private static final String SpotTag = "SpotOperation";
    private static final String WhitePointTag = "WhitePointOperation";
    private static final String GenericTag = "GenericOperation";
    private static final String OpTypeTag = "OperationType";

    public OpStack(Engine engine) {
        this.engine = engine;
        this.setLayout(null);
        this.opControls = new LinkedList();
        this.extraControls = new LinkedList();
        this.listeners = new LinkedList();
        this.addDraggableStackListener(new DraggableStackListener(){
            private List<Integer> swaps;

            @Override
            public void dragStarted() {
                this.swaps = new LinkedList<Integer>();
                OpStack.this.isStackDragging = true;
            }

            @Override
            public void swapped(int index) {
                this.swaps.add(index);
            }

            @Override
            public void dragStopped() {
                for (Integer index : this.swaps) {
                    OpStack.this.swap(index);
                }
                OpStack.this.isStackDragging = false;
            }
        });
        this.undoSupport = new OpStackUndoSupport();
        this.actions = new OpActions(engine, this);
        this.autoExpandControls = Prefs.getBoolean(AutoExpandKey, false);
    }

    public List<Action> getAddActions() {
        return this.actions.getActions();
    }

    public static List getStaticAddActions() {
        return OpActions.createStaticAddActions();
    }

    public OpControl addZoneControl() {
        int index = this.getOpControlCount();
        ZoneOperation op = this.engine.insertZoneOperation(index);
        ZoneControl control = new ZoneControl(op, this);
        this.addControl(control, index);
        return control;
    }

    public OpControl addCloneControl() {
        int index = this.getOpControlCount();
        CloneOperation op = this.engine.insertCloneOperation(index);
        CloneControl control = new CloneControl(op, this);
        this.addControl(control, index);
        return control;
    }

    public OpControl addSpotControl() {
        int index = this.getOpControlCount();
        SpotOperation op = this.engine.insertSpotOperation(index);
        SpotControl control = new SpotControl(op, this);
        this.addControl(control, index);
        return control;
    }

    public OpControl addWhitePointControl() {
        int index = this.getOpControlCount();
        WhitePointOperation op = this.engine.insertWhitePointOperation(index);
        WhitePointControl control = new WhitePointControl(op, this);
        this.addControl(control, index);
        return control;
    }

    public OpControl addGenericControl(OperationType type) {
        int index = this.getOpControlCount();
        return this.addGenericControl(type, index);
    }

    public OpControl addGenericControl(OperationType type, int index) {
        GenericOperation op = (GenericOperation)this.engine.insertOperation(type, index);
        GenericControl control = op instanceof ColorPickerDropperOperation ? new ColorPickerDropperControl((ColorPickerDropperOperation)op, this) : (op instanceof ColorDropperOperation ? (op instanceof RawAdjustmentOperation ? new RawAdjustmentControl((RawAdjustmentOperation)op, this) : new ColorDropperControl((ColorDropperOperation)op, this)) : (op instanceof ColorPickerOperation ? new ColorPickerControl((ColorPickerOperation)op, this) : new GenericControl(op, this)));
        this.addControl(control, index);
        return control;
    }

    public void addControl(SelectableControl control) {
        this.extraControls.add(control);
        int top = this.getOpControlCount();
        this.push(control, top);
        this.setSelection(control);
        this.revalidate();
    }

    List getLayerModes() {
        return this.engine.getLayerModes();
    }

    String getNextUniqueName(String baseName) {
        Integer countI = this.nameCounts.get(baseName);
        if (countI == null) {
            this.nameCounts.put(baseName, 1);
        }
        int count = this.nameCounts.get(baseName);
        String uniqueName = baseName + " " + count++;
        this.nameCounts.put(baseName, count);
        return uniqueName;
    }

    private void addControl(final OpControl control, final int index) {
        this.opControls.add(index, control);
        this.push(control, index);
        this.notifyControlAdded(control);
        this.setSelection(control);
        control.addUndoableEditListener(this);
        if (!this.undoSupport.isRestoring()) {
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    String name = control.getTitleText();
                    return Locale.LOCALE.get("AddToolEditName", name);
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.removeControl(control);
                    OpStack.this.undoSupport.restoreEnd();
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.restoreControl(control, index);
                }
            };
            this.undoSupport.postEdit(edit);
        }
        if (this.getAutoExpand()) {
            this.collapseAll();
            control.title.doExpand();
        }
        this.revalidate();
    }

    public void removeControl() {
        if (this.selection instanceof OpControl) {
            this.removeControl((OpControl)this.selection);
        }
    }

    public void removeControl(OpControl control) {
        int index = this.getOpIndexOf(control);
        this.removeOpControl(index);
    }

    public void removeControl(SelectableControl control) {
        if (this.selection == control) {
            this.setSelectionNext(control);
        }
        this.extraControls.remove(control);
        this.pop(control);
        this.resetFocus();
        this.revalidate();
        this.repaint();
    }

    private void removeOpControl(final int index) {
        final OpControl opControl = this.opControls.get(index);
        if (this.selection == opControl) {
            this.setSelectionNext(opControl);
        }
        this.opControls.remove(opControl);
        this.pop(opControl);
        this.notifyControlRemoved(opControl);
        this.engine.removeOperation(index);
        opControl.removeUndoableEditListener(this);
        if (!this.undoSupport.isRestoring()) {
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    String name = opControl.getTitleText();
                    return Locale.LOCALE.get("RemoveToolEditName", name);
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.restoreControl(opControl, index);
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.removeOpControl(index);
                    OpStack.this.undoSupport.restoreEnd();
                }
            };
            this.undoSupport.postEdit(edit);
        }
        this.resetFocus();
        this.revalidate();
        this.repaint();
    }

    private void restoreControl(OpControl control, int index) {
        this.undoSupport.restoreStart();
        Operation op = control.getOperation();
        OperationType type = op.getType();
        op = control instanceof ZoneControl ? this.engine.insertZoneOperation(index) : (control instanceof CloneControl ? this.engine.insertCloneOperation(index) : (control instanceof SpotControl ? this.engine.insertSpotOperation(index) : (control instanceof WhitePointControl ? this.engine.insertWhitePointOperation(index) : this.engine.insertOperation(type, index))));
        control.setOperation(op);
        this.addControl(control, index);
        this.undoSupport.restoreEnd();
    }

    private void resetFocus() {
        Container frame;
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component owner = focus.getFocusOwner();
        Container ancestor = SwingUtilities.getAncestorOfClass(OpStack.class, owner);
        if (ancestor == null && (frame = SwingUtilities.getAncestorOfClass(JFrame.class, this)) != null) {
            frame.requestFocusInWindow();
        }
    }

    void expand(final SelectableControl control) {
        if (control.isContentShown()) {
            return;
        }
        control.setShowContent(true);
        if (!this.undoSupport.isRestoring()) {
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return Locale.LOCALE.get("ExpandToolEditName");
                }

                @Override
                public boolean isSignificant() {
                    return false;
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.undoSupport.restoreStart();
                    control.title.doCollapse();
                    OpStack.this.undoSupport.restoreEnd();
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.undoSupport.restoreStart();
                    control.title.doExpand();
                    OpStack.this.undoSupport.restoreEnd();
                }
            };
            this.undoSupport.postEdit(edit);
        }
    }

    void collapse(final SelectableControl control) {
        if (!control.isContentShown()) {
            return;
        }
        control.setShowContent(false);
        if (!this.undoSupport.isRestoring()) {
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return Locale.LOCALE.get("CollapseToolEditName");
                }

                @Override
                public boolean isSignificant() {
                    return false;
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.undoSupport.restoreStart();
                    control.title.doExpand();
                    OpStack.this.undoSupport.restoreEnd();
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.undoSupport.restoreStart();
                    control.title.doCollapse();
                    OpStack.this.undoSupport.restoreEnd();
                }
            };
            this.undoSupport.postEdit(edit);
        }
    }

    void expandAll() {
        HashSet<OpControl> controls = new HashSet<OpControl>(this.opControls);
        controls.addAll(this.extraControls);
        for (SelectableControl selectableControl : controls) {
            selectableControl.title.doExpand();
        }
    }

    void collapseAll() {
        HashSet<OpControl> controls = new HashSet<OpControl>(this.opControls);
        controls.addAll(this.extraControls);
        for (SelectableControl selectableControl : controls) {
            selectableControl.title.doCollapse();
        }
    }

    void setAutoExpand(boolean autoExpand) {
        this.autoExpandControls = autoExpand;
        Prefs.putBoolean(AutoExpandKey, autoExpand);
    }

    boolean getAutoExpand() {
        return this.autoExpandControls;
    }

    public void setEngineActive(boolean active) {
        this.engine.setActive(active);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        RenderingHints hints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintChildren(g);
        g.setRenderingHints(hints);
    }

    public boolean canSwapDown(OpControl control) {
        OpControl first = this.opControls.getFirst();
        return !control.equals(first);
    }

    public boolean canSwapUp(OpControl control) {
        OpControl last = this.opControls.getLast();
        return !control.equals(last);
    }

    public void swapDown(OpControl control) {
        if (!this.canSwapDown(control)) {
            return;
        }
        int index = this.getOpIndexOf(control);
        this.swap(index - 1);
    }

    public void swapUp(OpControl control) {
        if (!this.canSwapUp(control)) {
            return;
        }
        int index = this.getOpIndexOf(control);
        this.swap(index);
    }

    private void swap(final int index) {
        OpControl controlA = this.opControls.get(index);
        OpControl controlB = this.opControls.get(index + 1);
        this.opControls.remove(controlA);
        this.opControls.remove(controlB);
        this.opControls.add(index, controlB);
        this.opControls.add(index + 1, controlA);
        this.engine.swap(index);
        if (!this.isStackDragging) {
            JComponent upper = this.pop(index);
            this.push(upper, index + 1);
        }
        if (!this.undoSupport.isRestoring()) {
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return Locale.LOCALE.get("SwapToolEditName");
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.swap(index);
                    OpStack.this.undoSupport.restoreEnd();
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.swap(index);
                    OpStack.this.undoSupport.restoreEnd();
                }
            };
            this.undoSupport.postEdit(edit);
        }
        this.revalidate();
    }

    public List<OpControl> getOpControls() {
        return new LinkedList<OpControl>(this.opControls);
    }

    private int getOpControlCount() {
        return this.opControls.size();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.height == 0) {
            size.height = 1;
        }
        return new Dimension(280, size.height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(280, Integer.MAX_VALUE);
    }

    public void addOpStackListener(OpStackListener listener) {
        this.listeners.add(listener);
    }

    public void removeOpStackListener(OpStackListener listener) {
        this.listeners.remove(listener);
    }

    private void setSelectionNext(SelectableControl control) {
        SelectableControl nextCtrl = null;
        if (control instanceof OpControl) {
            int index = this.opControls.indexOf(control);
            if (index > 0) {
                nextCtrl = this.opControls.get(index - 1);
            } else if (index < this.opControls.size() - 1) {
                nextCtrl = this.opControls.get(index + 1);
            } else if (this.opControls.size() == 1 && this.extraControls.size() > 0) {
                nextCtrl = this.extraControls.get(0);
            }
        } else {
            int index = this.extraControls.indexOf(control);
            if (index > 0) {
                nextCtrl = this.extraControls.get(index - 1);
            } else if (index < this.extraControls.size() - 1) {
                nextCtrl = this.extraControls.get(index + 1);
            } else if (this.opControls.size() > 0) {
                nextCtrl = this.opControls.get(this.opControls.size() - 1);
            }
        }
        this.setSelection(nextCtrl);
    }

    private void setSelection(SelectableControl control) {
        int index;
        if (this.selection == control) {
            return;
        }
        final SelectableControl oldSelection = this.selection;
        if (this.selection != null) {
            this.selection.setSelected(false);
            index = this.opControls.indexOf(this.selection);
            if (index >= 0) {
                this.engine.setSelectedOperation(index, false);
            }
        }
        this.selection = control;
        if (this.selection != null) {
            this.selection.setSelected(true);
            index = this.opControls.indexOf(control);
            if (index >= 0) {
                this.engine.setSelectedOperation(index, true);
            }
        }
        final SelectableControl newSelection = this.selection;
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return Locale.LOCALE.get("ToolSelectionEditName");
                }

                @Override
                public boolean isSignificant() {
                    return false;
                }

                @Override
                public void undo() {
                    super.undo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.setSelection(oldSelection);
                    OpStack.this.undoSupport.restoreEnd();
                }

                @Override
                public void redo() {
                    super.redo();
                    OpStack.this.undoSupport.restoreStart();
                    OpStack.this.setSelection(newSelection);
                    OpStack.this.undoSupport.restoreEnd();
                }
            });
        }
        this.notifySelectionChanged();
    }

    private void notifyControlAdded(OpControl control) {
        for (OpStackListener listener : this.listeners) {
            listener.opAdded(control);
        }
    }

    private void notifySelectionChanged() {
        for (OpStackListener listener : this.listeners) {
            if (this.selection instanceof OpControl) {
                listener.opChanged((OpControl)this.selection);
                continue;
            }
            listener.opChanged(this.selection);
        }
    }

    void notifyLockChanged(OpControl control) {
        for (OpStackListener listener : this.listeners) {
            listener.opLockChanged(control);
        }
    }

    private void notifyControlRemoved(OpControl control) {
        for (OpStackListener listener : this.listeners) {
            listener.opRemoved(control);
        }
    }

    private int getOpIndexOf(OpControl control) {
        int index = 0;
        for (OpControl c : this.opControls) {
            if (control.equals(c)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void save(XmlNode node) {
        for (OpControl control : this.opControls) {
            XmlNode child;
            if (control instanceof ZoneControl) {
                child = node.addChild(ZoneTag);
            } else if (control instanceof CloneControl) {
                child = node.addChild(CloneTag);
            } else if (control instanceof SpotControl) {
                child = node.addChild(SpotTag);
            } else if (control instanceof WhitePointControl) {
                child = node.addChild(WhitePointTag);
            } else {
                child = node.addChild(GenericTag);
                GenericOperation op = (GenericOperation)control.getOperation();
                OperationType opType = op.getType();
                child.setAttribute(OpTypeTag, opType.getName());
            }
            control.save(child);
        }
    }

    public void restore(XmlNode node) throws XMLException {
        this.undoSupport.restoreStart();
        int count = this.getOpControlCount();
        for (int n = count - 1; n >= 0; --n) {
            this.removeOpControl(n);
        }
        this.addControls(node);
        this.undoSupport.restoreEnd();
    }

    public List<OpControl> addControls(XmlNode node) throws XMLException {
        XmlNode[] children;
        LinkedList<OpControl> controls = new LinkedList<OpControl>();
        for (XmlNode child : children = node.getChildren()) {
            OpControl control = null;
            String tag = child.getName();
            if (tag.equals(ZoneTag)) {
                control = this.addZoneControl();
            } else if (tag.equals(CloneTag)) {
                control = this.addCloneControl();
            } else if (tag.equals(SpotTag)) {
                control = this.addSpotControl();
            } else if (tag.equals(WhitePointTag)) {
                control = this.addWhitePointControl();
            } else if (tag.equals(GenericTag)) {
                String typeTag = child.getAttribute(OpTypeTag);
                Collection<OperationType> types = this.engine.getGenericOperationTypes();
                for (OperationType type : types) {
                    if (!type.getName().equals(typeTag)) continue;
                    control = this.addGenericControl(type);
                    break;
                }
                if (control == null) {
                    throw new XMLException("Unrecognized GenericOperationType \"" + typeTag + "\"");
                }
            }
            if (control == null) continue;
            control.restore(child);
            control.readyForUndo();
            controls.add(control);
        }
        for (OpControl control : controls) {
            OpControl matchControl;
            if (!control.isRawCorrection() && !control.isSingleton() || (matchControl = this.getMatchingControl(control, controls)) == null) continue;
            int targetIndex = this.opControls.indexOf(matchControl);
            this.removeControl(matchControl);
            int index = this.opControls.indexOf(control);
            while (index > targetIndex && this.canSwapDown(control)) {
                this.swapDown(control);
                index = this.opControls.indexOf(control);
            }
        }
        return controls;
    }

    private OpControl getMatchingControl(OpControl control, List<OpControl> newControls) {
        OperationType type = control.getOperation().getType();
        if (control.isRawCorrection() || control.isSingleton()) {
            for (OpControl match : this.opControls) {
                OperationType matchType;
                if (newControls.contains(match) || !match.isRawCorrection() && !match.isSingleton() || !(matchType = match.getOperation().getType()).equals(type)) continue;
                return match;
            }
        }
        return null;
    }

    public boolean hasRawAdjustments() {
        OperationType rawType = this.engine.getGenericRawAdjustmentsOperationType();
        for (OpControl control : this.opControls) {
            Operation op = control.getOperation();
            OperationType type = op.getType();
            if (!type.getName().startsWith(rawType.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeControls(List<OpControl> controls) {
        for (OpControl control : controls) {
            if (!this.opControls.contains(control)) continue;
            this.removeControl(control);
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.removeUndoableEditListener(listener);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        this.undoSupport.postEdit(event.getEdit());
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height / 100;
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();

            @Override
            public void eventDispatched(AWTEvent awtEvent) {
                MouseEvent mEvent = (MouseEvent)awtEvent;
                if (mEvent.getID() == 501) {
                    Container stack;
                    Component comp = mEvent.getComponent();
                    Container control = SwingUtilities.getAncestorOfClass(SelectableControl.class, comp);
                    if (control == null && comp instanceof SelectableControl) {
                        control = (Container)comp;
                    }
                    if (control != null && (stack = SwingUtilities.getAncestorOfClass(OpStack.class, comp)) != null) {
                        ((OpStack)stack).setSelection((SelectableControl)control);
                        Component focused = this.focus.getFocusOwner();
                        if (focused instanceof JTextField && !(comp instanceof JTextField)) {
                            this.focus.upFocusCycle();
                        }
                    }
                }
            }
        }, 16L);
        Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/operation");
    }

    private class OpStackUndoSupport
    extends UndoableEditSupport {
        private boolean restoring;

        private OpStackUndoSupport() {
        }

        @Override
        public void postEdit(UndoableEdit edit) {
            if (!this.restoring) {
                super.postEdit(edit);
            }
        }

        private void restoreStart() {
            this.restoring = true;
        }

        private void restoreEnd() {
            this.restoring = false;
        }

        private boolean isRestoring() {
            return this.restoring;
        }
    }
}

