/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.mode;

import com.lightcrafts.ui.mode.AbstractMode;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.utils.WeakHashSet;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class DropperMode
extends AbstractMode {
    private final List<Listener> m_listeners;
    private final JComponent m_overlay;
    private AffineTransform m_xform;
    private final OpControl m_opControl;
    private static final Set<DropperMode> m_dropperModes = new WeakHashSet<DropperMode>();
    private static final Cursor DropperCursor;
    private static final Point DropperHotPoint;

    public DropperMode(OpControl opControl) {
        this.m_opControl = opControl;
        m_dropperModes.add(this);
        this.m_overlay = new DropperOverlay();
        this.m_overlay.setCursor(DropperCursor);
        this.m_overlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DropperMode.this.notifyPointSelected(me.getPoint());
            }
        });
        this.m_listeners = new LinkedList<Listener>();
    }

    public void addListener(Listener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void enter() {
        for (DropperMode dm : m_dropperModes) {
            if (dm == this || dm.m_opControl != this.m_opControl || !dm.isIn()) continue;
            this.m_opControl.notifyListenersExitMode(dm);
        }
        super.enter();
    }

    @Override
    public JComponent getOverlay() {
        return this.m_overlay;
    }

    public void removeListener(Listener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.m_overlay.addMouseListener(listener);
        this.m_overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.m_overlay.removeMouseListener(listener);
        this.m_overlay.removeMouseMotionListener(listener);
        this.notifyModeCancelled();
    }

    @Override
    public void setTransform(AffineTransform xform) {
        this.m_xform = xform;
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    private Point2D invertPoint(Point2D p) {
        if (this.m_xform == null) {
            return (Point2D)p.clone();
        }
        try {
            return this.m_xform.inverseTransform(p, null);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException("Scaling failed", e);
        }
    }

    private void notifyModeCancelled() {
        for (Listener listener : this.m_listeners) {
            listener.modeCancelled();
        }
    }

    private void notifyPointSelected(Point2D p) {
        p = this.invertPoint(p);
        for (Listener listener : this.m_listeners) {
            listener.pointSelected(p);
        }
    }

    static {
        DropperHotPoint = new Point(3, 19);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String path = "resources/dropper_cursor.png";
        URL url = DropperMode.class.getResource("resources/dropper_cursor.png");
        Image image = toolkit.createImage(url);
        DropperCursor = toolkit.createCustomCursor(image, DropperHotPoint, "Dropper");
    }

    private static final class DropperOverlay
    extends JComponent {
        private DropperOverlay() {
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }

    public static interface Listener {
        public void pointSelected(Point2D var1);

        public void modeCancelled();
    }
}

