/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.metadata2.MetadataStack;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class MetadataScroll
extends JScrollPane {
    private MetadataStack stack;
    private ImageInfo info;

    public MetadataScroll(ImageInfo info) {
        this();
        this.setImage(info);
    }

    public MetadataScroll() {
        this.setOpaque(true);
        this.getViewport().setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        this.setBorder(LightZoneSkin.getPaneBorder());
    }

    public void setImage(ImageInfo info) {
        File thisFile;
        File file;
        if (this.stack != null && this.stack.isEditing() && this.info != null && info != null && (file = info.getFile()).equals(thisFile = this.info.getFile())) {
            return;
        }
        this.endEditing();
        this.info = info;
        if (info != null) {
            if (this.stack != null) {
                this.stack.setImage(info);
            } else {
                this.stack = new MetadataStack(info);
            }
            this.getViewport().add(this.stack);
        } else {
            this.getViewport().removeAll();
            this.repaint();
        }
    }

    public void refresh() {
        File file;
        if (this.info != null && (file = this.info.getFile()) != null) {
            this.info = ImageInfo.getInstanceFor(file);
            this.setImage(this.info);
        }
    }

    public void endEditing() {
        if (this.stack != null && this.stack.isEditing()) {
            this.stack.endEditing();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: MetadataScroll (file)");
            System.exit(1);
        }
        System.setProperty("apple.awt.antialiasing", "false");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.awt.textantialiasing", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("swing.aatext", "true");
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        File file = new File(args[0]);
        ImageInfo info = ImageInfo.getInstanceFor(file);
        MetadataScroll scroll = new MetadataScroll(info);
        scroll.getViewport().setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        JFrame frame = new JFrame("MetadataScroll Test");
        frame.setContentPane(scroll);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

