/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.action.ToggleAction;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.FileActions;
import com.lightcrafts.ui.browser.view.ImageDatumRenderer;
import com.lightcrafts.ui.browser.view.LeadSelectionAction;
import com.lightcrafts.ui.browser.view.Locale;
import com.lightcrafts.ui.browser.view.RatingActions;
import com.lightcrafts.ui.browser.view.RotateActions;
import com.lightcrafts.ui.browser.view.SelectionAction;
import com.lightcrafts.ui.browser.view.TemplateProvider;
import com.lightcrafts.utils.file.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class ImageBrowserActions {
    static File TemplateClipboard;
    private AbstractImageBrowser browser;
    private LeadSelectionAction editAction;
    private LeadSelectionAction copyAction;
    private SelectionAction pasteAction;
    private SelectionAction refreshAction;
    private SelectionAction leftAction;
    private SelectionAction rightAction;
    private LeadSelectionAction renameAction;
    private Action selectLatestAction;
    private Action selectAllAction;
    private SelectionAction selectNoneAction;
    private List<SelectionAction> ratingActions;
    private SelectionAction clearRatingAction;
    private ToggleAction showHideTypesAction;
    private Action showAction;
    private SelectionAction trashAction;

    ImageBrowserActions(AbstractImageBrowser b) {
        this.browser = b;
        this.editAction = new LeadSelectionAction("EditMenuItem", this.browser, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageDatum lead = this.getLeadDatum();
                ImageBrowserActions.this.browser.notifyDoubleClicked(lead);
            }
        };
        this.copyAction = new LeadSelectionAction("CopyMenuItem", this.browser, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageDatum datum = this.getLeadDatum();
                TemplateClipboard = datum.getFile();
            }

            @Override
            void update() {
                super.update();
                if (this.isEnabled()) {
                    ImageDatum lead = this.getLeadDatum();
                    ImageDatumType type = lead.getType();
                    boolean hasLzn = type.hasLznData();
                    ImageBrowserActions.this.copyAction.setEnabled(hasLzn);
                }
            }
        };
        this.pasteAction = new SelectionAction(Locale.LOCALE.get("PasteMenuItem"), this.browser, null, true, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                List<ImageDatum> selection = this.getSelection();
                ArrayList<File> files = new ArrayList<File>();
                for (ImageDatum datum : selection) {
                    File file = datum.getFile();
                    files.add(file);
                }
                TemplateProvider templates = ImageBrowserActions.this.browser.getTemplateProvider();
                templates.applyTemplate(TemplateClipboard, files.toArray(new File[0]));
            }

            @Override
            void update() {
                super.update();
                if (this.isEnabled()) {
                    TemplateProvider templates = ImageBrowserActions.this.browser.getTemplateProvider();
                    List<ImageDatum> selection = this.getSelection();
                    boolean hasTemplates = templates != null;
                    boolean hasSelection = !selection.isEmpty();
                    boolean hasClipboard = TemplateClipboard != null;
                    this.setEnabled(hasTemplates && hasSelection && hasClipboard);
                }
            }
        };
        this.refreshAction = new SelectionAction(Locale.LOCALE.get("RefreshMenuItem"), this.browser, null, true, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<ImageDatum> selection = this.getSelection();
                for (ImageDatum datum : selection) {
                    datum.refresh(false);
                }
            }
        };
        this.ratingActions = RatingActions.createRatingActions(this.browser, true);
        this.clearRatingAction = RatingActions.createClearRatingAction(this.browser, true);
        this.leftAction = RotateActions.createRotateLeftAction(this.browser, true);
        this.rightAction = RotateActions.createRotateRightAction(this.browser, true);
        this.renameAction = new LeadSelectionAction("RenameMenuItem", this.browser, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageDatum datum = ImageBrowserActions.this.browser.getLeadSelectedDatum();
                FileActions.renameFile(datum.getFile(), ImageBrowserActions.this.browser);
            }
        };
        this.selectLatestAction = new AbstractAction(Locale.LOCALE.get("SelectLatestActionName")){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageBrowserActions.this.browser.selectLatest();
            }
        };
        this.selectLatestAction.setEnabled(true);
        this.selectAllAction = new AbstractAction(Locale.LOCALE.get("SelectAllActionName")){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageBrowserActions.this.browser.selectAll();
            }
        };
        this.selectAllAction.setEnabled(true);
        String modifier = Platform.getType() == Platform.MacOSX ? "meta" : "ctrl";
        this.selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(modifier + " " + "A"));
        this.selectNoneAction = new SelectionAction(Locale.LOCALE.get("SelectNoneActionName"), this.browser, null, true, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageBrowserActions.this.browser.clearSelection();
            }
        };
        this.showHideTypesAction = new ToggleAction(Locale.LOCALE.get("HideImageTypeMenuItem"), Locale.LOCALE.get("ShowImageTypeMenuItem")){

            @Override
            protected void onActionPerformed(ActionEvent event) {
                ImageDatumRenderer.setShowImageTypes(true);
                ImageBrowserActions.this.browser.repaint();
            }

            @Override
            protected void offActionPerformed(ActionEvent event) {
                ImageDatumRenderer.setShowImageTypes(false);
                ImageBrowserActions.this.browser.repaint();
            }
        };
        this.showHideTypesAction.setState(ImageDatumRenderer.doesShowImageTypes());
        this.trashAction = new SelectionAction(Locale.LOCALE.get("TrashMenuItem"), this.browser, null, true, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList<ImageDatum> datums = ImageBrowserActions.this.browser.getSelectedDatums();
                ArrayList<File> files = new ArrayList<File>();
                for (ImageDatum datum : datums) {
                    File file = datum.getFile();
                    files.add(file);
                }
                FileActions.deleteFiles(files.toArray(new File[0]), ImageBrowserActions.this.browser);
            }
        };
        this.showAction = new SelectionAction(Locale.LOCALE.get("ShowMenuItem"), this.browser, null, true, true){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList<ImageDatum> datums = ImageBrowserActions.this.browser.getSelectedDatums();
                ArrayList<File> files = new ArrayList<File>();
                for (ImageDatum datum : datums) {
                    File file = datum.getFile();
                    files.add(file);
                }
                Platform platform = Platform.getPlatform();
                for (File file : files) {
                    file = FileUtil.resolveAliasFile(file);
                    String path = file.getAbsolutePath();
                    platform.showFileInFolder(path);
                }
            }
        };
    }

    public Action getEditAction() {
        return this.editAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getShowFileInFolderAction() {
        return this.showAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public List<Action> getRatingActions() {
        return new ArrayList<Action>(this.ratingActions);
    }

    public Action getClearRatingAction() {
        return this.clearRatingAction;
    }

    public Action getLeftAction() {
        return this.leftAction;
    }

    public Action getRightAction() {
        return this.rightAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public Action getSelectLatestAction() {
        return this.selectLatestAction;
    }

    public Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public Action getSelectNoneAction() {
        return this.selectNoneAction;
    }

    public ToggleAction getShowHideTypesAction() {
        return this.showHideTypesAction;
    }

    public Action getTrashAction() {
        return this.trashAction;
    }
}

