/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCJPEGReader;
import com.lightcrafts.image.libs.LCJPEGWriter;
import com.lightcrafts.image.libs.OutputStreamImageDataReceiver;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.ui.browser.model.FastImageFactory;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageProviderReceiver;
import com.lightcrafts.ui.browser.model.Thumbnailer;
import com.lightcrafts.utils.filecache.FileCache;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageTask
implements Runnable {
    public static final int CacheImageSize = 320;
    private ImageDatum datum;
    private FileCache cache;
    private int size;

    ImageTask(ImageDatum datum, FileCache cache, int size, boolean useCache) {
        this.datum = datum;
        this.cache = cache;
        this.size = size;
        if (!useCache) {
            this.clearImageCache();
        }
    }

    @Override
    public void run() {
        ImageMetadata meta = this.datum.getMetadata(true);
        RenderedImage image = null;
        if (!this.datum.isBadFile() && this.cache != null && (image = this.readImageCache()) != null) {
            image = Thumbnailer.rotate(image, meta);
        }
        if (!this.datum.isBadFile() && image == null) {
            File file = this.datum.getFile();
            image = Thumbnailer.getImage(file, 320);
            if (image != null) {
                if (this.cache != null) {
                    this.writeImageCache(image);
                }
                image = Thumbnailer.rotate(image, meta);
            } else {
                this.datum.setBadFile();
            }
        }
        if (image != null) {
            image = this.fixSizeAndColors(image);
            this.datum.setImage(image);
        }
        this.datum.markClean();
    }

    private RenderedImage fixSizeAndColors(RenderedImage image) {
        image = Thumbnailer.constrainImage(image, this.size);
        image = FastImageFactory.createFastImage(image);
        return image;
    }

    private void logNonFatal(Throwable t, String message) {
        File file = this.datum.getFile();
        StringBuffer buffer = new StringBuffer();
        buffer.append(file.getAbsolutePath());
        buffer.append(" ");
        buffer.append(message);
        buffer.append(" ");
        buffer.append(t.getClass().getName());
        if (t.getMessage() != null) {
            buffer.append(": ");
            buffer.append(t.getMessage());
        }
        System.err.println(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage readImageCache() {
        PlanarImage planarImage;
        String key = this.getImageKey(320);
        if (this.cache == null || !this.cache.contains(key)) {
            return null;
        }
        FileInputStream in = this.cache.getStreamFor(key);
        try {
            ImageProviderReceiver provRecv = new ImageProviderReceiver();
            provRecv.fill(in);
            LCJPEGReader jpeg = new LCJPEGReader(provRecv, 320, 320);
            planarImage = jpeg.getImage();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Throwable t1) {
                this.logNonFatal(t1, "reading cached image");
                this.removeCacheSilent(key, false);
                return null;
            }
        }
        ((InputStream)in).close();
        return planarImage;
    }

    private void writeImageCache(RenderedImage image) {
        String key = this.getImageKey(320);
        if (this.cache == null) {
            return;
        }
        if (image == null) {
            return;
        }
        try {
            FileOutputStream out = this.cache.putToStream(key);
            OutputStreamImageDataReceiver receiver = new OutputStreamImageDataReceiver(out);
            try {
                LCJPEGWriter writer = new LCJPEGWriter(receiver, 32768, image.getWidth(), image.getHeight(), image.getColorModel().getNumComponents(), 2, 90);
                writer.putImage(image);
            }
            catch (LCImageLibException e) {
                this.logNonFatal(e, "caching image");
                this.cache.remove(key);
            }
            out.flush();
            ((OutputStream)out).close();
            receiver.dispose();
        }
        catch (IOException e) {
            this.logNonFatal(e, "caching image");
            this.removeCacheSilent(key, false);
        }
    }

    private String getImageKey(int size) {
        File file = this.datum.getFile();
        return ImageTask.getImageKey(file, size);
    }

    public static String getImageKey(File file) {
        return ImageTask.getImageKey(file, 320);
    }

    public static String getImageKey(File file, int size) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(file.getAbsolutePath());
        buffer.append("_thumbnail_image_");
        buffer.append(size);
        return buffer.toString();
    }

    private void clearImageCache() {
        String key = this.getImageKey(320);
        if (this.cache != null && this.cache.contains(key)) {
            this.removeCacheSilent(key, false);
        }
    }

    private void removeCacheSilent(String key, boolean log) {
        block2: {
            try {
                this.cache.remove(key);
            }
            catch (Throwable t) {
                if (!log) break block2;
                this.logNonFatal(t, "removing cached image");
            }
        }
    }
}

