/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderTree;
import com.lightcrafts.ui.browser.folders.FolderTreeSelectionModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class FolderTreeTransferHandler
extends TransferHandler {
    private FolderTree tree;

    FolderTreeTransferHandler(FolderTree tree) {
        this.tree = tree;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavs) {
        for (DataFlavor flav : flavs) {
            if (!flav.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable trans) {
        try {
            List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
            for (Object o : files) {
                File file = (File)o;
                System.out.println(file.getAbsolutePath());
            }
            FolderTreeSelectionModel selection = (FolderTreeSelectionModel)this.tree.getSelectionModel();
            File folder = selection.getDropFolder();
            System.out.println(folder != null ? folder.getAbsolutePath() : null);
            this.tree.notifyDropAccepted(files, folder);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

