/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class MemoryMeter
extends JComponent {
    private static final long UpdateInterval = 1000L;
    private static final Dimension PreferredSize = new Dimension(110, 20);
    private static final Color MemoryColor = new Color(100, 168, 242);
    private static final Runtime RtInstance = Runtime.getRuntime();
    private static final long MaxMemory = RtInstance.maxMemory();
    private static long usedMemory;
    private static final List<MemoryMeter> Instances;
    private static final Thread Updater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryMeter() {
        List<MemoryMeter> list = Instances;
        synchronized (list) {
            Instances.add(this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return PreferredSize;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = size.width - insets.left - insets.right;
        int h = size.height - insets.top - insets.bottom;
        GradientPaint paint = new GradientPaint(x, y, Color.white, 0.0f, h / 2, MemoryColor, true);
        int mem = (int)Math.round((double)((long)size.width * usedMemory) / (double)MaxMemory);
        Graphics2D g = (Graphics2D)graphics;
        Paint oldPaint = g.getPaint();
        g.setPaint(paint);
        g.fillRect(x, y, mem, h);
        g.setPaint(oldPaint);
        String text = MemoryMeter.getText();
        Font font = g.getFont();
        FontRenderContext fontContext = g.getFontRenderContext();
        TextLayout layout = new TextLayout(text, font, fontContext);
        Rectangle2D textBounds = layout.getBounds();
        int textH = x + (int)Math.round((double)w - textBounds.getWidth()) / 2;
        int textV = y + (int)Math.round((double)h + textBounds.getHeight()) / 2;
        g.drawString(text, textH, textV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<MemoryMeter> list = Instances;
        synchronized (list) {
            Instances.remove(this);
        }
    }

    private static String getText() {
        long usedMegs = usedMemory >> 20;
        long maxMegs = MaxMemory >> 20;
        String text = "" + usedMegs + "M of " + maxMegs + "M";
        return text;
    }

    static {
        Instances = new LinkedList<MemoryMeter>();
        Updater = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String text = null;
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    usedMemory = RtInstance.totalMemory() - RtInstance.freeMemory();
                    if (MemoryMeter.getText().equals(text)) continue;
                    text = MemoryMeter.getText();
                    List list = Instances;
                    synchronized (list) {
                        for (MemoryMeter instance : Instances) {
                            if (!instance.isShowing()) continue;
                            instance.repaint();
                        }
                    }
                }
            }
        }, "Memory Meter Updater");
        Updater.setDaemon(true);
        Updater.start();
    }
}

