/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.templates;

import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateKey
implements Comparable<TemplateKey> {
    private static Pattern NamePattern = Pattern.compile("(?:([^;]*);)?(.*)");
    private String namespace;
    private String name;
    private File file;

    public static TemplateKey importKey(File file) {
        return new TemplateKey(new File(TemplateDatabase.TemplateDir, file.getName()));
    }

    public TemplateKey(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        String encodedNamespace = FileUtil.encodeFilename(namespace);
        String encodedName = FileUtil.encodeFilename(name);
        this.file = new File(TemplateDatabase.TemplateDir, encodedNamespace + ';' + encodedName + ".lzt");
    }

    TemplateKey(File file) {
        this.file = file;
        String fileName = file.getName();
        String baseName = FileUtil.trimExtensionOf(fileName);
        Matcher matcher = NamePattern.matcher(baseName);
        String encodedNamespace = matcher.replaceAll("$1");
        String encodedName = matcher.replaceAll("$2");
        this.namespace = FileUtil.decodeFilename(encodedNamespace);
        this.name = FileUtil.decodeFilename(encodedName);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        if (!this.namespace.equals("")) {
            return this.namespace + ';' + this.name;
        }
        return this.name;
    }

    @Override
    public int compareTo(TemplateKey o) {
        return this.toString().compareTo(o.toString());
    }
}

